#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-KHwyqlRT8uq4KliO3neHti
key:                  aeson-2.1.2.1-KHwyqlRT8uq4KliO3neHti
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  31bf29f7a893a84baf4ea72c153fe279
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-KHwyqlRT8uq4KliO3neHti
depends:
    OneTuple-0.4.2-Bo8xNKpGy1UYfy8Yfg8Yf
    QuickCheck-2.15.0.1-8WOZKPDaVcqBn81v5fpGVL
    attoparsec-0.14.4-1LkqTl6pHdPB5xyeiPPJjY base-4.17.2.1
    base-compat-batteries-0.14.1-4nbhCC5zHOy26otbn0yrZb
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-BKJqv3c582yBVzzP7ZA02a deepseq-1.4.8.0
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI exceptions-0.10.5
    generically-0.1.1-BMmSQ7WpcrdGUFJLOaMnA7 ghc-prim-0.9.1
    hashable-1.4.7.0-DYciMpMadITBAfaAGwGb6s
    indexed-traversable-0.1.4-2qPrf1t5YAY7xsGgNpQfIy
    primitive-0.9.1.0-2xanABVx1x5I4qjrdAPB07
    scientific-0.3.8.0-FzkpGwEDtoiC1o6P6Xyy7X
    semialign-1.3.1-1fEl3xrub7a1fP0OOTOzrp
    strict-0.5.1-4Eow0DmhRwiFt599ngSgFT
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-HHFPb0WMffaJn6XiaqctfN
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-32kOmuTWEPpAC6H0SzzClS time-1.12.2
    time-compat-1.9.8-3Q6moV5o5KUFZhw5QOloyo
    unordered-containers-0.2.20.1-L9h8TvnOBH1Ihya3LZF9bU
    uuid-types-1.0.6-DKR25ZFLBpO2YUc64KYEVz
    vector-0.13.2.0-EKABDCAVgb42yYEtp4rYAX
    witherable-0.4.2-KZkEeM3BFDxJY3GlA6FsZz

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

