#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-FLNpA1kYfSp7ISjZQSk2AY
key:                  aeson-2.1.2.1-FLNpA1kYfSp7ISjZQSk2AY
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  5de8bda56109b4fe892feb3cf20376cc
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-FLNpA1kYfSp7ISjZQSk2AY
depends:
    OneTuple-0.4.2-AfDBhfzf4f6LoM7aM8JNRh
    QuickCheck-2.15.0.1-DUSZjYYOgXECqf7Svaitv8
    attoparsec-0.14.4-Fn7js8xKpz57gY212YnEkw base-4.17.2.1
    base-compat-batteries-0.14.1-U6oJNZTSkZ98vyVKlNGlN
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-3BgI7u8wrFL6BoJm9GWjXY deepseq-1.4.8.0
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI exceptions-0.10.5
    generically-0.1.1-KghsyPEZCaL4wXeGvTOuCA ghc-prim-0.9.1
    hashable-1.4.6.0-AVmZwVVVmv9PclG6VBq0Z
    indexed-traversable-0.1.4-2WKTkNkgrfi8m9oX1GafX8
    primitive-0.9.1.0-4gbRHMYHSCF2lptKn8Ww53
    scientific-0.3.8.0-JQaes2jq5DMI9DamxBEckf
    semialign-1.3.1-27NjX2iiGpF942TTudTbM4
    strict-0.5-AmIPEDMooWLGM58L0V1WEW
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-9tH02BGTOIY7rW1KWbbUGp
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-5oFU8ZiSNbuJGmFkFSeKyk time-1.12.2
    time-compat-1.9.7-JEUYb8ZhfwDI7vSxfKkRLL
    unordered-containers-0.2.20-9npXt9Xm1lq5WoODUfmSXc
    uuid-types-1.0.6-BA9ln5TQ9lwLn8jGokdpgn
    vector-0.13.2.0-E9z8CkzpYQwAFSNyB7dwgD
    witherable-0.4.2-6CbrwexSiqTP301qBkVV5

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

