#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-IZ8jLcnEISD7S5Vyf2Tehm
key:                  aeson-2.1.2.1-IZ8jLcnEISD7S5Vyf2Tehm
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  da315f157edb054091da9ddb2f621875
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-IZ8jLcnEISD7S5Vyf2Tehm
depends:
    OneTuple-0.4.2-8Jmt0O4mVzdHn3v89Wjjtv
    QuickCheck-2.15.0.1-7dsjbuPrJB87A5nQdB1dNE
    attoparsec-0.14.4-IXbcbJGX0cBC8WVvSy4ntj base-4.17.2.1
    base-compat-batteries-0.14.0-3gC1PBuH1KFL4KQJUkv7J0
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-1oDV29qiF3YBr3NVTbnbqA deepseq-1.4.8.0
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI exceptions-0.10.5
    generically-0.1.1-Jt5JSZr9pJdKu3u5aFdPBO ghc-prim-0.9.1
    hashable-1.4.5.0-FhpNKvHQsJeLXuGJFx8piW
    indexed-traversable-0.1.4-SYv5547dJK2gDTDCEMijk
    primitive-0.9.1.0-IjHZubyRsLN7SdbALfq7Lq
    scientific-0.3.8.0-JtTPeMck4RoCJw8PpYbrMQ
    semialign-1.3.1-8LkQR0slb4M4jfWDA3j77O
    strict-0.5-7CI4Y0pG7lW9rFarilxCeX
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-Eu53Zq5IEYR7y41LFWcVVu
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-38ZEYendZwGe95pzapKOQ time-1.12.2
    time-compat-1.9.7-Io8xc72y5DiIwyIvSiIEs9
    unordered-containers-0.2.20-79maJZZuZDu8bRI1CHuoJG
    uuid-types-1.0.6-HYU7viivqgX5aZerV0Z0Cp
    vector-0.13.2.0-9TreTxHfwqF7cSCfMWPj9u
    witherable-0.4.2-IlqLZUwKRwSY4QoXbWfpZ

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

