#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-GhEX0nU3rpe2rpNz8TrqEz
key:                  aeson-2.1.2.1-GhEX0nU3rpe2rpNz8TrqEz
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  48559318c6f6f0d090c996d6023961c7
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-GhEX0nU3rpe2rpNz8TrqEz
depends:
    OneTuple-0.4.2-Lg0KiSsiju9IOzV5RKNgvH
    QuickCheck-2.15.0.1-5w6er91snjk1ibuLJ886ps
    attoparsec-0.14.4-CZt0qAnGZHQHCYZEsndAye base-4.17.2.1
    base-compat-batteries-0.13.1-GsVVRNKJTtvKSFmNxivv77
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-2JmTWGVlfn1Dx25eNDpOfJ deepseq-1.4.8.0
    dlist-1.0-E99MqJW5mmB4kr4PCgIESI exceptions-0.10.5
    generically-0.1.1-Kqn3ZNAFQKQ4g4PbhNFWxI ghc-prim-0.9.1
    hashable-1.4.4.0-GXwYNb6ixbL0AOxKKxOK7
    indexed-traversable-0.1.4-IdrLHXCvQGN9TboScqmWoy
    primitive-0.9.1.0-8nzcMUtKW4yAfvV7oeRfvP
    scientific-0.3.8.0-IWovBluCcknEjldn22iWzh
    semialign-1.3.1-6s5yGaepKAeJd443QLiEDl
    strict-0.5-CYtrz6ex3zRE6u7xR738Z9
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-DYsQc8gAFXc15ZZAqS83Cn
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-B0u6f4KDalOHT1Mh1U0Tln time-1.12.2
    time-compat-1.9.7-3E0y9Kbz85AH1LDhF7bIrJ
    unordered-containers-0.2.20-psp1ib8v1R5J9F619BTWH
    uuid-types-1.0.6-2pjrbgdQn07HQQ1wqykLkX
    vector-0.13.2.0-BxFNQQxQb2S1T9ycXEZ0Cs
    witherable-0.4.2-GSDrK0JJ1chBLV1nrpgBA0

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

