#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-Eu0ZMA1fvZJ7acphaZ1YUp
key:                  aeson-2.1.2.1-Eu0ZMA1fvZJ7acphaZ1YUp
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  8e2023cda3e3bcf179355b2c3d4f9345
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-Eu0ZMA1fvZJ7acphaZ1YUp
depends:
    OneTuple-0.4.2-5DyQFzq8WA51jg2V77K4Uo
    QuickCheck-2.14.3-J45WF0Yux319EMk6f3cLwH
    attoparsec-0.14.4-AaLxHw66o7ZDAbKIqXiED8 base-4.17.2.1
    base-compat-batteries-0.13.1-6cmuG0uMRzDH7v5qzvpFRM
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.4-48cXvQcshtj1tNVGAndj5R deepseq-1.4.8.0
    dlist-1.0-BKgPi70fx5AJreCYiKxIIN exceptions-0.10.5
    generically-0.1.1-77c7A3JPevpBiH0k8ueG2h ghc-prim-0.9.1
    hashable-1.4.4.0-HmFtE5Wyl97MxSGTvKCoh
    indexed-traversable-0.1.4-3Mq4EBXbmCUGTMDLGSN4EO
    primitive-0.9.1.0-6oaPYJdlxXvFbCd1QkYYcO
    scientific-0.3.8.0-hGLqISimekA59HuDEk96u
    semialign-1.3.1-4FymHK5uIZq3TBpRzOVm6y
    strict-0.5-KlaHQ53dvGmCgPJqRttB9a
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-5tdBq4uv374KgT7qGb8rUa
    th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    these-1.2.1-UV9eNKBSmILiNLB0mgeck time-1.12.2
    time-compat-1.9.7-BZ2MctONxQ2JS4AX8s9tlp
    unordered-containers-0.2.20-5YE9FG6zPmjDjdA4DCPpEY
    uuid-types-1.0.6-HsEJaNxEgFx55hazgJEfvI
    vector-0.13.2.0-2If6MrCrP3g55Bnhb5dowG
    witherable-0.4.2-MSPT5MwxCPKVW5yr09lCp

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

