/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.util.ArrayList;
import java.util.Set;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.internal.artifacts.configurations.ResolutionHost;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.LenientConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;

public class DefaultResolvedConfiguration
implements ResolvedConfiguration {
    private final VisitedGraphResults graphResults;
    private final ResolutionHost resolutionHost;
    private final VisitedArtifactSet visitedArtifacts;
    private final LenientConfigurationInternal configuration;

    public DefaultResolvedConfiguration(VisitedGraphResults graphResults, ResolutionHost resolutionHost, VisitedArtifactSet visitedArtifacts, LenientConfigurationInternal configuration) {
        this.graphResults = graphResults;
        this.resolutionHost = resolutionHost;
        this.visitedArtifacts = visitedArtifacts;
        this.configuration = configuration;
    }

    public boolean hasError() {
        return this.graphResults.hasAnyFailure();
    }

    public void rethrowFailure() throws ResolveException {
        if (!this.graphResults.hasAnyFailure()) {
            return;
        }
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        this.graphResults.visitFailures(failures::add);
        this.resolutionHost.rethrowFailuresAndReportProblems("dependencies", failures);
    }

    public LenientConfiguration getLenientConfiguration() {
        return this.configuration;
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
        this.rethrowFailure();
        return this.configuration.getFirstLevelModuleDependencies();
    }

    public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
        ArtifactCollectingVisitor visitor = new ArtifactCollectingVisitor();
        this.visitedArtifacts.select(this.configuration.getImplicitSelectionSpec()).visitArtifacts(visitor, false);
        this.resolutionHost.rethrowFailuresAndReportProblems("artifacts", visitor.getFailures());
        return visitor.getArtifacts();
    }
}

