#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40.1
visibility:           public
id:                   glirc-2.40.1-BY7QbqjaCka5voe1zuvBid
key:                  glirc-2.40.1-BY7QbqjaCka5voe1zuvBid
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  e20a6b76bc879cffe83d5cee901e6049
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Docs Client.Commands.Exec
    Client.Commands.Interpolation Client.Commands.Operator
    Client.Commands.Queries Client.Commands.Recognizer
    Client.Commands.TabCompletion Client.Commands.Toggles
    Client.Commands.Types Client.Commands.Window
    Client.Commands.WordCompletion Client.Commands.ZNC
    Client.Configuration Client.Configuration.Colors
    Client.Configuration.Macros Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.Docs Client.EventLoop Client.EventLoop.Actions
    Client.EventLoop.Errors Client.EventLoop.Network Client.Hook
    Client.Hook.DroneBLRelay Client.Hook.Matterbridge
    Client.Hook.Snotice Client.Hook.Znc.Buffextras Client.Hooks
    Client.Image Client.Image.Layout Client.Image.LineWrap
    Client.Image.Message Client.Image.MircFormatting
    Client.Image.PackedImage Client.Image.Palette
    Client.Image.StatusLine Client.Image.Textbox Client.Log Client.Mask
    Client.Message Client.Network.Async Client.Network.Connect
    Client.Options Client.State Client.State.Channel
    Client.State.EditBox Client.State.EditBox.Content
    Client.State.Extensions Client.State.Focus Client.State.Network
    Client.State.Url Client.State.Window Client.UserHost Client.View
    Client.View.Cert Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40.1-BY7QbqjaCka5voe1zuvBid
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40.1/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-7rM3XcO073UGlPooPcpWFC
    async-2.2.5-LqkzH7L8HyYHud0cQFVYjz
    attoparsec-0.14.4-a7MjceIUMFKMmgfXk7t7H base-4.17.2.1
    base64-bytestring-1.2.1.0-LWeAHO93Hqh8w1c79M45du
    bytestring-0.11.5.3 config-schema-1.3.0.0-4Xbc9t1LBk041A6BlBwuAP
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-BrsH7QQHdY9K1TCZof2zWk directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-GOXyGkKD2t8G8Y0JGBsX36
    githash-0.1.6.3-Ig5oaRupCrJLV3orW32rWG
    hashable-1.4.4.0-BPBogvz51gTFqjBeDWtSVb
    hookup-0.8-16nwMYSwYtu99sSvrKk5We
    irc-core-2.12-D7QQEjwnpVb2BLJYEeSjeQ
    kan-extensions-5.2.7-DgkCJ4JnGiu2sR18wrApzp
    lens-5.3.1-9oQplfPnoWr2g52V8zm4go
    network-3.1.4.0-9ZkyLgutzTZFWrHs4BgIgX
    psqueues-0.2.8.2-DVfgkMwDlBk4u8YRi7JEXz
    random-1.2.1.3-AojK1F3ExhxDorHTlNe3sA
    regex-tdfa-1.3.2.4-F7fHSRmw2rGDNk5aODvyIV
    semigroupoids-6.0.1-9Wq7OVzTmCiAXe4kmGdK06
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-5s6beENsz5QGgEm8AvbBll
    unix-2.7.3 unordered-containers-0.2.20-7dvM9aaOf5JATet72j0BPX
    vector-0.13.2.0-JDMr93x2QgFDQPvksTJZzq
    vty-6.2-55mKoYhJwgZFNQHqx5sRNX

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

