#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40
visibility:           public
id:                   glirc-2.40-CXhFK5lN8d27yfwtTCWwdz
key:                  glirc-2.40-CXhFK5lN8d27yfwtTCWwdz
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  cb75daaca5423ed9bc733b8da61b9a4f
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Url
    Client.State.Window Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40-CXhFK5lN8d27yfwtTCWwdz
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-BVbk2de6J26KSXmqVbDukY
    async-2.2.5-CnIXSKDP2zb9wDuJeUMBSG
    attoparsec-0.14.4-4RzuPxfXaMJ4ix17ZyY6Fu base-4.17.2.1
    base64-bytestring-1.2.1.0-JFfbIOEHhMLiXtjStIWLc bytestring-0.11.5.3
    config-schema-1.3.0.0-GDKnDUBEuVlD83uxVtN1FK
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-HxocbSGuUCsC8rHU2HJ3hI directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-3lxHOZ3HA538Pa6VHTjVaM
    githash-0.1.6.3-96IhZpn9SlrE3hEICB14Vi
    hashable-1.4.4.0-AxDm5kAgNA5AvAaNWXByLz
    hookup-0.8-92sMV8RX1UvImgXMcMOpa2
    irc-core-2.12-EOng1PUUQQkCtwFdOc9V08
    kan-extensions-5.2.7-Du5J0XJy1DqC036fYp4w8B
    lens-5.3-ED1w0iWbeCnCotHHsV7jBB
    network-3.1.4.0-2pW4Myf1qC42hlDsYfTCI2
    psqueues-0.2.8.1-6SKetrVPzZL1Qb4azWGYHq
    random-1.2.1.3-AmMEPPUxLvDF0ipgbYNtgb
    regex-tdfa-1.3.2.4-Ct0IFBScpTvJWq7GC94rxP
    semigroupoids-6.0.1-47cluUNVvr3AK3j10UdWEE
    split-0.2.5-JeJxVdKJRKMda8iubaxqh stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-BVuMC1Gm96811mCvgVrSk2
    unix-2.7.3 unordered-containers-0.2.20-8pr2L2RDRM8Dqz21gIQp5G
    vector-0.13.2.0-5yTDFxdzRoNJu0VJvStUzF
    vty-6.2-GcNayMMp7mjC2wYRKosgzo

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

