#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40
visibility:           public
id:                   glirc-2.40-8ovFA8mh0Cl7qaZrhvkbis
key:                  glirc-2.40-8ovFA8mh0Cl7qaZrhvkbis
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  d7c09822f5474a6130ecc5e578f3d35c
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Url
    Client.State.Window Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40-8ovFA8mh0Cl7qaZrhvkbis
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-mAci6xXuEb3ZJRGhx0O78
    async-2.2.5-EKzjtytxFSDGO33P7IPwKj
    attoparsec-0.14.4-7XWZ3nsZOGKJDEorzXp6qF base-4.17.2.1
    base64-bytestring-1.2.1.0-3xTWh9pwP9a781vByOHbcb
    bytestring-0.11.5.3 config-schema-1.3.0.0-9auQN6GUGX72NI8TBEkYzg
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-ISbosYRk8rP8Eyk1fAjg6z directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-1VadUHgfoPu9wU2v7YEGOG
    githash-0.1.6.3-IJkW43TZ4GBH6AqemX18id
    hashable-1.4.4.0-2lvxXC6j7O5I2GR31C0SqX
    hookup-0.8-DBO3QE3VHjC2bP6Tdqx2DR
    irc-core-2.12-7fpuCIB6oRAIMEiudvIhpK
    kan-extensions-5.2.7-IZ8l155Co8K2v4OSOt29Hs
    lens-5.3.1-L3T26fDKV8KAh84K9wN8lF
    network-3.1.4.0-Be19ySMD4vC3IuDyb1IMcQ
    psqueues-0.2.8.2-AaA7EVl31z1Eq2y6esSN4g
    random-1.2.1.3-ddmLWvz8i69p1T3sgcHVE
    regex-tdfa-1.3.2.4-JxlpWSNK7Gn8iVLoEpbxIK
    semigroupoids-6.0.1-6UDNhnrCcmB8qcD4TESfdi
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-BcJkYOXpKZ99YcOjhyaQSN
    unix-2.7.3 unordered-containers-0.2.20-G9Xtyt8hv5K8HhfrH8JX1r
    vector-0.13.2.0-K0fBmK5qd7y3388236ZS0A
    vty-6.2-7q7ChOhYPGRAEcCH9L5SOt

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

