#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40
visibility:           public
id:                   glirc-2.40-EKUHATh7sz1Ij6ZVb5sjBb
key:                  glirc-2.40-EKUHATh7sz1Ij6ZVb5sjBb
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  5a7d41f4e5ae40416802f2fe05ccff48
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Url
    Client.State.Window Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40-EKUHATh7sz1Ij6ZVb5sjBb
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-4zdXUDvk3kbBJwucU20WNX
    async-2.2.5-8qrDbV8xcFXEsDmo0VTM7z
    attoparsec-0.14.4-H9Y4iLHDqcP1CPr5BByOUl base-4.17.2.1
    base64-bytestring-1.2.1.0-G53UOvB3pKB2mwL6yBWItW
    bytestring-0.11.5.3 config-schema-1.3.0.0-G8R4NvTaUKu9MKANJwDo70
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8.1-RP99Sg511m4gXHu1Jr6TF directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-9GdMxvKWSiEFB1WLTUVZK
    githash-0.1.6.3-8p2dyBfw224LS8k9E3SN4
    hashable-1.4.4.0-5SoCNaysfySGuPwu0aljBu
    hookup-0.8-JfYiSFPXrA3GIiCmH2MJVc
    irc-core-2.12-LFzSLdcq8miCwl6IZ7A4IO
    kan-extensions-5.2.7-4LdAmv8w4EfC985l4Y3DVd
    lens-5.3.1-1UDi0CjALHfJ5iQ7KsOF6H
    network-3.1.4.0-AsoxBmMP1pfJSzv0IgKvnl
    psqueues-0.2.8.2-3iKKGlnRxG5E2Sjr2SGPa6
    random-1.2.1.3-9I8x2ZdyyN6LUBxcAUCXuW
    regex-tdfa-1.3.2.4-I1xViAJsheQFW1DER7LPSU
    semigroupoids-6.0.1-Ajxt1MUD1pH7gUEFlchfjE
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.13.0-HfGN0hphLYH7Zw28lE9c2c
    unix-2.7.3 unordered-containers-0.2.20-AeV3HTkHtCc6BQ9fzLSSB8
    vector-0.13.2.0-52P7Ozt5w3I6hi4WvheJB9
    vty-6.2-CDHlYy103TUGR9Lrhlf8g8

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

