#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-5sZDpCQNoSG72ITdLresCp
key:                  gitit-0.15.1.2-5sZDpCQNoSG72ITdLresCp
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  a163321dc4a0926fe931539492aee55b
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-5sZDpCQNoSG72ITdLresCp
depends:
    HStringTemplate-0.8.8-LSsMIEy2lpTHx5i7GnZ2M4
    HTTP-4000.4.1-LXcOO85bKTdH5DnkDtc68v
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-3LOl3stht3x9JybSpHkoQT base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    blaze-html-0.9.2.0-HlrZxLZUUWY3inTlediNEQ bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-99q5uhLOerGIRthJrI7oHO
    feed-1.3.2.1-DdE7clkx0ve6ECCW476yjl filepath-1.4.2.2
    filestore-0.6.5.1-C0ljuNQc9ehBJmh7J3TV6A ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-3j9NgnAOL0a2IUkuMJS95x
    hoauth2-2.13.0-DK00WnaAuhhBfITGAtunyk
    hslogger-1.3.2.0-8brmtmtSRGxFCWqCWZlV0O
    http-client-tls-0.3.6.4-EFTVUXlq4cM19RusFvekJW
    http-conduit-2.3.9.1-ACc0PY7fQ3546ONqFA19yU
    json-0.10-FWcAVmVZmOr7FLg44i8con mtl-2.2.2
    network-3.1.4.0-1n8WDlzhAQUHYfqI16mYdv
    network-bsd-2.8.1.0-9blh8PjPb8A8jGe3Fzprnu
    network-uri-2.6.4.2-KmmPt5MfJi07BPtstNPoD0
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.4-7bAfkpNrsOqHhdAJLbpAGN
    pandoc-types-1.23.1-4PdVS2SJqvF1JyHlvdR6Jk parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-1QsPqNiQGepFTMKcu0aMcs
    recaptcha-0.1.0.4-Hpz4Y9Qmvil60OmWUtB44n
    safe-0.3.21-DkSUsNQd5PECw0GboXg9Ze
    skylighting-0.14.3-8yz2zeLdh91CVjMJP0VNJY
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-6hZpCMnOgIw3sb7LbwnFLW
    tagsoup-0.14.8-HFs2WU3taYSEIu1vUARVvd
    temporary-1.3-7OlUYGsOxiE5dNsZFuxKnV text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-HmRrL9N3WOWKNVIU05LIhA
    url-2.1.3-6FPO2w3YSWEHKkuOJOrzI4
    utf8-string-1.0.2-4OrQf1vZkgOAJqnDO7nv41
    uuid-1.3.16-4s9AN1K355r8CxDgaQNiHy xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-HeToZQfn8xl4La8Cfm2IjS
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-5lMzPcGKtVWILjPY5McL2U
    zlib-0.7.0.0-GmXsdmOezz3ojQH5A3eIK

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

