#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-8mNZ8vhiGMN8LIASjqzir3
key:                  gitit-0.15.1.2-8mNZ8vhiGMN8LIASjqzir3
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  f174598b47a5f7375f862b636416bdd1
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-8mNZ8vhiGMN8LIASjqzir3
depends:
    HStringTemplate-0.8.8-4nAsRwygXtmIZbhtzZDO7w
    HTTP-4000.4.1-UQPYAP8yUgEjcbz6DYqOp
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-9rGsBPhyshTKvPzkopJx8r base-4.17.2.1
    base64-bytestring-1.2.1.0-IO7W4nLtABNJGIN4Jp2MEQ
    blaze-html-0.9.2.0-A6Vi4VW5MkkDRUuOYiyz4t bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-GDbfmdwl5uUAiz0AoJo20F
    feed-1.3.2.1-EFSyxw0uyhh1GHS9INfseB filepath-1.4.2.2
    filestore-0.6.5.1-EpzZnK5ecQ12Aee9QWO4mU ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-LCTo1mznd6S2ENDreRqszb
    hoauth2-2.13.0-DecvO2NVsz493sG1VIygQv
    hslogger-1.3.2.0-4k6rmECVslK3xi6RME0F7b
    http-client-tls-0.3.6.4-Im2XpqDar4e3QdicCLXH1Y
    http-conduit-2.3.9.1-9qkXzivBSFLHFHLEhYWVOm
    json-0.10-31IckNhfrHMFHAMVZxIpWD mtl-2.2.2
    network-3.1.4.0-7fNpNYdJiSEL43akp61gqU
    network-bsd-2.8.1.0-Lq0tAd8hfNdLGvVc2Ok6LV
    network-uri-2.6.4.2-FfZCDPDUWea9JZl5JGUmKF
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.4-DY6mZHXHN4WDaM1SY0galZ
    pandoc-types-1.23.1-10ERTHkIQl98bdxKqE9Rpy parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-8ADb21VvJl3AtsgmJLZ0Jg
    recaptcha-0.1.0.4-HBdqJZz8Wj8CukjBoUkDhB
    safe-0.3.21-h7eXfPvXuk1aMCYRfiuDr
    skylighting-0.14.3-306TpIxSaKHy6X5rhsKXb
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-Dk2TUQSTxWd5yTqOEWpD7k
    tagsoup-0.14.8-2IXVCK7wAML5lleGSzoKmr
    temporary-1.3-AlI9ORly2zXB5n2ZaDEM2 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-4B4JBhnfLZ0FVT7oeq6NL4
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-Fy32w0af5sx1X9unRKjPMO xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-GkCcWqtKyEaLTCbsrDZIQ5
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-JUKfaocNzUJEPZcac4wtrg
    zlib-0.7.0.0-CWCQOp9WY8aARLfbxZwOd5

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

