#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-8f7UKXLVSfQLeuzfrg3YYi
key:                  gitit-0.15.1.2-8f7UKXLVSfQLeuzfrg3YYi
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  ff35da778dd3d35627eedca3f7489c38
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-8f7UKXLVSfQLeuzfrg3YYi
depends:
    HStringTemplate-0.8.8-3dyMl3sytIFbumMyBqwhu
    HTTP-4000.4.1-I2ydKJTUXZBAgs2phAJYvL
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-FLNpA1kYfSp7ISjZQSk2AY base-4.17.2.1
    base64-bytestring-1.2.1.0-7CU13IWnWdcDMU9nDc25iT
    blaze-html-0.9.2.0-JJrFCr8DvKJ7H4iqC8zkVN bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-7YIJs80CSADEggTr6WCfg9
    feed-1.3.2.1-4EHgvsORpIuHqmsOB9NgJb filepath-1.4.2.2
    filestore-0.6.5.1-4UvDsSA2xJN3tq0aQLtvNn ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-CX381RofTJuJ9gSnZg4cOs
    hoauth2-2.13.0-LrjMI5pr8x2LpXHFhDJEQg
    hslogger-1.3.2.0-4rBqGiWU8FDIT0F2kbnZAH
    http-client-tls-0.3.6.4-GETcVgF6bXAgw5zWx32D
    http-conduit-2.3.9.1-Ett5GXtAkZH5bqOT2HIt8b
    json-0.10-DoYY2nxPc4DFrHt3TRIJUi mtl-2.2.2
    network-3.1.4.0-9ttathdcL583NH2Tw8H5yc
    network-bsd-2.8.1.0-D3RfxMWM5HtDhrH9ytPEEn
    network-uri-2.6.4.2-9yi2QA7rgaeGDUVDh4qvx3
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.3-AR3lHe0SNr42T68VBDcjhu
    pandoc-types-1.23.1-7DX1WlSAkhgLOIWTroEwDR parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-53eBMyqCn4j5j5sTN6ACJa
    recaptcha-0.1.0.4-hT91EdjNRm2jOMO9GZgjC
    safe-0.3.21-18jAQK8jji87dfRYhZ3RVp
    skylighting-0.14.3-HOnKuaflcWe3AY4lF2IO6G
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-GR8SQUvypud7ZjWJ9MTjse
    tagsoup-0.14.8-83zXaykHbsCJ0WP8qVDxXs
    temporary-1.3-J42K7A8FBeY81ggJOcRHJy text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-6uyca4C6VVh5xrSgITo2jU
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-JZldhWwp7KFJM7wY1nGxWy xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-CsCexfiEqzv7b0CDBObFkT
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-4K7xa1MBO1t2Sd3Yn9fqKw
    zlib-0.7.0.0-8DVkszQ06lWAUuiI4YHYzG

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

