#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-2Xjsj7m5tfqIL6yFeBG94c
key:                  gitit-0.15.1.2-2Xjsj7m5tfqIL6yFeBG94c
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  2b061e25bb537324f8fa4cb9d6bbf39c
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-2Xjsj7m5tfqIL6yFeBG94c
depends:
    HStringTemplate-0.8.8-3ZlKk7m4PyXL0sh7zs8tWj
    HTTP-4000.4.1-6bnazPJw5a135lGIcwDsL7
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-CoFGCad0PesDH4XC5ctCv4 base-4.17.2.1
    base64-bytestring-1.2.1.0-H7PD9x3a1R75H5UmP3m5CT
    blaze-html-0.9.2.0-5UHR2rFfuO85rrjBAwZQF8 bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-DcZqx3UNBEhGKyqiW3oFsw
    feed-1.3.2.1-BzX9ruykjX0EzL6BTJLzO4 filepath-1.4.2.2
    filestore-0.6.5.1-16fkgUeO8bC215TszQnwFp ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.3-2N6og3nfXdILtIlBmaNbqG
    hoauth2-2.13.0-AsyBoHUb347C3Wj82FtQmc
    hslogger-1.3.2.0-KTme06vKoen5Ls9AzMi6nW
    http-client-tls-0.3.6.4-LGF2WOi7ToiLbJydJMsCzM
    http-conduit-2.3.9.1-9Uv6XpRhxDvK3s54aNa7vF
    json-0.10-32Q0HWOHvRKIBOS2LDdoSH mtl-2.2.2
    network-3.1.4.0-K2TPJT2eLM87X4awxEjMbA
    network-bsd-2.8.1.0-HIdXID9b3ZfGs3EGTT10Ie
    network-uri-2.6.4.2-4IxerK0JG7wGRLJekUQEdr
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2.1-HFKbuybiPXO5FqL4kf3ETq
    pandoc-types-1.23.1-7gWDUsUafgnGN4MZXQBBdX parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-3lKZsy50ahFJstdbQE9KC3
    recaptcha-0.1.0.4-32Zl3kHNNW34x10jokNQNo
    safe-0.3.21-ByjvVtJLwt5KrRntZowDKh
    skylighting-0.14.2-A6jM5G7lF8lFr2Jm627wge
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-JxKwJKAj8VO69Skm5xz2vL
    tagsoup-0.14.8-6SzAK0LrK3QBWvkf6keIrz
    temporary-1.3-GqTQQZxhgaKHMmG7i0IazO text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-A1DZrFi8Yoz44bdiRDxdgu
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-BbBIX8gTPF4DLSeQ6wlETQ xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-1ZIfFj0ZGuFFWAbq6vXb0B
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-7Qh8CAMJ4cnN9GgJCgrHz
    zlib-0.7.0.0-5J8qtSnxQ9lBB7H0QqMVmL

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

