#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-DkOMwuAsyLyAOJGrrAdVvM
key:                  gitit-0.15.1.2-DkOMwuAsyLyAOJGrrAdVvM
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  de69bb646a752dd62c0039da1fea51e7
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-DkOMwuAsyLyAOJGrrAdVvM
depends:
    HStringTemplate-0.8.8-BFFxaGYzyClKeVHNV9iJMs
    HTTP-4000.4.1-FN7heqcBJOQDZygSpN8A4E
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-LvJWrHbVhNW5j5NGQeCpIT base-4.17.2.1
    base64-bytestring-1.2.1.0-2WioaI2OOHv6enJjm95P5G
    blaze-html-0.9.2.0-97pJC8dBTXf5qZAc9J115X bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-IrzzCmgwUhtG6iaNmX8yGe
    feed-1.3.2.1-EKwKlIRmzVT3ZIFmRA4gd4 filepath-1.4.2.2
    filestore-0.6.5.1-GMlOpZtauHq3w4K40nGqJi ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.2-4FiN9ihSit8Uw2FVAbQms
    hoauth2-2.12.0-Ajp86wWn3Ph3yxi2h6ZG6q
    hslogger-1.3.2.0-LbQHdu1407K3Abhs0Xw2Vi
    http-client-tls-0.3.6.4-GiVBNNbKgJLCx3fO8pPpRI
    http-conduit-2.3.9.1-6m79Y0ZNJvKK9qOtarTSOn
    json-0.10-4uMzBO1Ibly6G0epDEG0CP mtl-2.2.2
    network-3.1.4.0-FZePtqluqyjFxAKIHdZ8Kd
    network-bsd-2.8.1.0-5jzZ1ELDSHDINHpEZPQZwF
    network-uri-2.6.4.2-U3v26HNy1l6rJ9sPiQ7eG
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-72Dx3UJk1GzKu5P1JWLOxC
    pandoc-types-1.23.1-DjdaEWTNF5lHiiG7qu2IsH parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-FjAccEVuGQcK7S7DSNXHmd
    recaptcha-0.1.0.4-2OpWRb7dnl8HCWDJTlGmwc
    safe-0.3.21-5ePY1yCKz45qNPHFPlOcS
    skylighting-0.14.2-9MPcsTY4zKVS4JfUoquBF
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-ACTF8Kj0RcZBTcmzP0xOXB
    tagsoup-0.14.8-4DDKeCqs06PDSmZSBF0VEA
    temporary-1.3-5WcjY7uJWNv1MIS9W1UhrX text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-LOBJrtZ0gah7XW774dnn7s
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-GfAccKynmdCGdPbxZEzCze xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-ClYmWYtZnVGBt5jjOED7ry
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-C4BtIMULcRv7DTAChUwwAT
    zlib-0.7.0.0-9Zx3bu1purBDV0Kt6BJOMV

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

