#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-BIKXv24o6sZKUSbW79ffn0
key:                  gitit-0.15.1.2-BIKXv24o6sZKUSbW79ffn0
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  17bbdb68e196f583dd610c1b18b78d54
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-BIKXv24o6sZKUSbW79ffn0
depends:
    HStringTemplate-0.8.8-DqReXADpl6a3niFA4Or9Hu
    HTTP-4000.4.1-DfdmXPglDtF9oOKX0n1geD
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-GhEX0nU3rpe2rpNz8TrqEz base-4.17.2.1
    base64-bytestring-1.2.1.0-1ZLaOmG6271EszdgVZtDyi
    blaze-html-0.9.2.0-EVafAfeFFsi6uTiWDNT8VW bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-DNp9bGuy5Fv5bmpcsHoGf
    feed-1.3.2.1-7eicYEHcXHT98uS6P4xMLs filepath-1.4.2.2
    filestore-0.6.5.1-GNYelHhU5cSFtg25FkVdHR ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.2-ILNYGlRUhqS75xcreWu0ZP
    hoauth2-2.11.0-EzFH2scTQ9Z9EOXtyNELQB
    hslogger-1.3.2.0-Rdxd4vyzh270nIj87AhRt
    http-client-tls-0.3.6.4-ASsMA44245pH60llfmtwLM
    http-conduit-2.3.9.1-7muBD1166MhJslMFfttyN
    json-0.10-GrgDp0AKt8A29OeuATu8B7 mtl-2.2.2
    network-3.1.4.0-GjkG889aAvvIfieaCEFwUy
    network-bsd-2.8.1.0-7JhnebMOt6tDObZ2unKpJt
    network-uri-2.6.4.2-E36L5Munrgj3tkxSsgYpcw
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-2uqKSIsmnpp1RNnPkikxan
    pandoc-types-1.23.1-EBFpM1a7ZeK5zzcZ1qQdHi parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-DyhQJBMZMiBKToaxsRw6jM
    recaptcha-0.1.0.4-43ndAhHcgZd3j0RPu4UL6z
    safe-0.3.21-5tBPY9DXWHX1cPmFJ7tzkO
    skylighting-0.14.2-KnTTRQoCKtu8xafAcNrtEN
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q syb-0.7.3-82kecYkSnotJhXSs3T6xq0
    tagsoup-0.14.8-CFoU20xEFBlEl57PKxJ3VY
    temporary-1.3-CsfJBYeBgjZ51GnRh5ob84 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-Dy1gXtAoi0KJabYCKmvX8d
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-LSzdtMEZY34D3FkWOtBUzx xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-5Skvz2pSEQwBW23AfjaET7
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-HXyKj4eiFsLK97C4oEj06S
    zlib-0.7.0.0-6noX1S9YwgbHMaaC248h30

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

