#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-J0YtR77Zi9lJF7uR7Owv1t
key:                  gitit-0.15.1.2-J0YtR77Zi9lJF7uR7Owv1t
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  09eab5ca067e7469574b70ba39fb4857
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-J0YtR77Zi9lJF7uR7Owv1t
depends:
    HStringTemplate-0.8.8-FT6SzQYxStQJ7fouUkFuoW
    HTTP-4000.4.1-9SogL1ploXw5esj5RJ2575
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-9cza8YJPY5Z8Ze3x8zf5ig base-4.17.2.1
    base64-bytestring-1.2.1.0-Cf5znIQf1Nf25Cl2XqzapR
    blaze-html-0.9.2.0-LlU0XfzVpg34MJkFx2EZcl bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-AMBMd1RJLs26yzcfwlu8Fz
    feed-1.3.2.1-8bW23NxZA1X5bKi00wfxBY filepath-1.4.2.2
    filestore-0.6.5.1-KcfMfr7Xbz851qkeKoFBiX ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-7EzCHKyQlTfFEjNHaZHb2R
    hoauth2-2.11.0-8TfYSRBbbXL2IN2PowijOr
    hslogger-1.3.2.0-3OfRhND7Zsp4rzF9j06Ouq
    http-client-tls-0.3.6.4-1BDRKQL1P8oJwrUsm96xXK
    http-conduit-2.3.9.1-2oN63nNuS8WGGNMCJvNhJ6
    json-0.10-12GqGJxyea7KvEBUFlezs0 mtl-2.2.2
    network-3.1.4.0-DD61ZgteIR5Dyq0QRyt6FX
    network-bsd-2.8.1.0-1C6YjGmBnfRK8ZiHSsWzwY
    network-uri-2.6.4.2-IX03DIUVxPAG8S8nkSZaDU
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-ENWCdHA16PlEL5OfVQPDzb
    pandoc-types-1.23.1-2jedVNew2xB36sQgMgJsQb parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-Dut5c8vSKZWHge6fwh5bUA
    recaptcha-0.1.0.4-4QmrSkfoXcO6ED3jrDlOxl
    safe-0.3.21-3NYlWmvK5NXAlxNW2aDsvC
    skylighting-0.14.2-CRUofeX5hi21Wg4NpYinpu
    split-0.2.5-42FGdeEiiUOLLQR1FNYPlK syb-0.7.3-2eqzyzFtMWK8QFmS6IKpDr
    tagsoup-0.14.8-AMyiZ86JbZ144ESmOgZhsu
    temporary-1.3-Hhl2LRPiMvQ4xmTU7fPXaD text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-8CSZEt4zEzRDd64NJlBCaw
    url-2.1.3-HH0TccKaktc7b8I8qoi3h7
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm
    uuid-1.3.16-GJSG7HiE4PXIztKocWTNuc xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-HZKzsMGpoYKGE5hBj7zsBz
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-6GURqdLdCyZAjOKZxfpUbC
    zlib-0.7.0.0-BbtlWgNylq2Ayu89f0aigE

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

