#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-8tfxIAEG3TkIxKW7STL2yJ
key:                  gitit-0.15.1.2-8tfxIAEG3TkIxKW7STL2yJ
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  804fe7f6b52ed9b2ca26bbe7588d09e3
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-8tfxIAEG3TkIxKW7STL2yJ
depends:
    HStringTemplate-0.8.8-AAgL6yWilt2MGssKRS4US
    HTTP-4000.4.1-3BKWylAoIulCWc1PZ3yKLf
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-8PRfz0Kg6mwK2TOn7o5BkY base-4.17.2.1
    base64-bytestring-1.2.1.0-3xTWh9pwP9a781vByOHbcb
    blaze-html-0.9.2.0-DybkQGKrSyk6JOAprz1r5T bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-5AGXeJdAkVd4qEUdHEj94x
    feed-1.3.2.1-817wDXbSsLV2o4NYaV6dC7 filepath-1.4.2.2
    filestore-0.6.5.1-KMH8ptgqaY9kpHz9INuOh ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-4uXSjm1y6nvEcitshymTQc
    hoauth2-2.11.0-2BiN8xgQZUeIwIWffufZMx
    hslogger-1.3.2.0-9kzx7KroDjh9YP49KKwNy2
    http-client-tls-0.3.6.4-5o70DrNWX5xB18veidzZPC
    http-conduit-2.3.9.1-GCaa2XuTyJGz4mDlubaVt
    json-0.10-DRBuvbQyt9L7OQ7mtzYh9P mtl-2.2.2
    network-3.1.4.0-KmVGd8MQrab5lGMy9eMLcZ
    network-bsd-2.8.1.0-4ZHkZ3KKwVlBl6Wc9TVocQ
    network-uri-2.6.4.2-KCWNlmsAWh8C1z4az19KdT
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-CtxyxfPgs2LWdrj2ckDW9
    pandoc-types-1.23.1-IjOJdxF4LkyCWyGf8Jj2Pk parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-AItr1WcsEfaHebdgTnBQBQ
    recaptcha-0.1.0.4-3oQSjeZDNWj5dNPetRlTBc
    safe-0.3.21-HL4mjR4LPAfAu0GeFkJLe6
    skylighting-0.14.2-KuCvqRJpqbVEHirYDvziFx
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV syb-0.7.3-L4OhoYbUcQQ8vXL0yfxnA4
    tagsoup-0.14.8-6EsVKdjovRMCb6RRUniCAg
    temporary-1.3-6YbEjLKDNjc6IO1VlPHH38 text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-8eH0QIBRYE24iMAwDt8EQp
    url-2.1.3-5jqeZ5XJ7ppHdpwVy0F3TG
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    uuid-1.3.16-95bIAEFK6KQ74QGAgxfLvk xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-BUXtvIF7FaDKr2gbaHe7V9
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-J4ySGFCVAXn2THnlTIZKNd
    zlib-0.7.0.0-JbjVQGZKr912ZiOqa2LP90

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

