#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-9vUzkrdqQSgD94H1OavJYy
key:                  gitit-0.15.1.2-9vUzkrdqQSgD94H1OavJYy
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  a79699b1598f35d27866ae5c3b243dee
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-9vUzkrdqQSgD94H1OavJYy
depends:
    HStringTemplate-0.8.8-89ZVHAABss3BveYPE8RL3C
    HTTP-4000.4.1-3l2nQR5K1y1GlvXAnTn661
    SHA-1.6.4.4-8ksu987L0xnDMFbhBLiacl
    aeson-2.1.2.1-JD8QPsoBF4NC1qVY6ch6us base-4.17.2.1
    base64-bytestring-1.2.1.0-3xTWh9pwP9a781vByOHbcb
    blaze-html-0.9.2.0-DBNekIonl9ZHQcEIbEIyEL bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1
    doctemplates-0.11.0.1-fmKL6KoMX9IJEFTYzMjSv
    feed-1.3.2.1-1vcZjEIzc7B6drFCe40eeF filepath-1.4.2.2
    filestore-0.6.5.1-Bt6h51mNWzd4Kz9fP5uDAT ghc-9.4.8
    ghc-paths-0.1.0.12-8lmZj1VFo8V7iNy4rcXCyj
    happstack-server-7.9.2.1-45OOvraJlSmBy7wViciWf2
    hoauth2-2.11.0-KPKwH0drYUb3UV6Gtynsr6
    hslogger-1.3.1.2-3FwL9KjqlQLEl0iYZ5aC9x
    http-client-tls-0.3.6.4-5Ho7Yjl7j7WL01BIog0cDK
    http-conduit-2.3.9.1-FP2JCCSsfhQ1fNIoAuOJFp
    json-0.10-BtosyBEbArHHoQJgkbqAxx mtl-2.2.2
    network-3.1.4.0-IWANZy3yTdDGDiy7NHyKoQ
    network-bsd-2.8.1.0-Ip06HBEyAHcIf1OU1b2EE3
    network-uri-2.6.4.2-37qi4fIAhTC8owHWseusWs
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9
    pandoc-3.2-HFoL8Xp2vO69DxqVqJ3JUk
    pandoc-types-1.23.1-Cga5O8NxtC2uCoAPmAGoA parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.18.0
    random-1.2.1.3-7QJJoQOVHAI1PeONmcyhZ
    recaptcha-0.1.0.4-DaoF0GHYUss5WodKqVyXAb
    safe-0.3.21-9VHQIWglBzGFIkoEOx5WCO
    skylighting-0.14.1.2-7lNYYyu45jTAi3dY1i9qbh
    split-0.2.5-HF22Q1cIKmoK4fHDRbSUwV
    syb-0.7.2.4-5o1aA7VmoIW8wlDGJbJzgh
    tagsoup-0.14.8-KdgsyTTit5HDjgJu9AD36q
    temporary-1.3-5ykvKjhsciDABbzBam51Ha text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-5tXJEkzutebLFGJSCLf2vw
    url-2.1.3-5jqeZ5XJ7ppHdpwVy0F3TG
    utf8-string-1.0.2-FAQSGuIUGqDKZx6mH04y15
    uuid-1.3.16-6LbWjn0qtVGBCyQuJNCPsW xhtml-3000.2.2.1
    xml-1.3.14-Lx2FeToC7XoDX0aDGC9dRG
    xml-conduit-1.9.1.4-BJceWXDYyV23FUTLjf16Py
    xml-types-0.3.8-IpGyuvvNOu2AH1SOobl25
    xss-sanitize-0.3.7.2-CGyvxe3y4e6IVy34ZoPxR8
    zlib-0.7.0.0-2F0fuaZf5oXJH9n2vtc6Ea

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

