/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.xml.dtd;

import io.sf.carte.uparser.TokenControl;
import io.sf.carte.uparser.TokenHandler;
import io.sf.carte.uparser.TokenHandler2;
import io.sf.carte.uparser.TokenProducer;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class EntityFinder {
    private final EntityResolver2 resolver;
    private static final int DTD_SIZE_LIMIT = 0x100000;

    public EntityFinder(EntityResolver2 entityResolver2) {
        this.resolver = entityResolver2;
    }

    public int findEntities(Map<Integer, String> map, Reader reader) throws IOException {
        DTDTokenHandler dTDTokenHandler = new DTDTokenHandler(map);
        int[] nArray = new int[]{60, 33};
        TokenProducer tokenProducer = new TokenProducer((TokenHandler2)dTDTokenHandler, nArray, 0x100000);
        try {
            tokenProducer.parse(reader, "<!--", "-->");
        }
        catch (StopParsingException stopParsingException) {
            // empty catch block
        }
        return dTDTokenHandler.mapCount;
    }

    private class DTDTokenHandler
    implements TokenHandler {
        private final Map<Integer, String> codePoint2Entity;
        private int mapCount = 0;
        private final int mapInitialSize;
        private byte stage = 0;
        private String lastEntity = null;

        DTDTokenHandler(Map<Integer, String> map) {
            this.codePoint2Entity = map;
            this.mapInitialSize = map.size();
        }

        public void tokenStart(TokenControl tokenControl) {
        }

        public void word(int n, CharSequence charSequence) {
            if ("<!ENTITY".contentEquals(charSequence)) {
                this.stage = 1;
            } else if (this.stage == 1) {
                this.lastEntity = charSequence.toString();
                this.stage = (byte)2;
            } else if (this.stage == 10) {
                if ("SYSTEM".contentEquals(charSequence)) {
                    this.stage = (byte)11;
                }
            } else {
                this.stage = (byte)-1;
            }
        }

        public void separator(int n, int n2) {
        }

        public void quoted(int n, CharSequence charSequence, int n2) {
            if (this.stage == 2) {
                int n3;
                if (charSequence.charAt(2) == 'x') {
                    String string = charSequence.subSequence(3, charSequence.length() - 1).toString();
                    try {
                        n3 = Integer.parseInt(string, 16);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.stage = (byte)-1;
                        return;
                    }
                }
                String string = charSequence.subSequence(2, charSequence.length() - 1).toString();
                try {
                    n3 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.stage = (byte)-1;
                    return;
                }
                if (this.codePoint2Entity.containsKey(n3) && this.codePoint2Entity.get(n3) == null) {
                    this.codePoint2Entity.put(n3, this.lastEntity);
                    ++this.mapCount;
                    if (this.mapCount + this.mapInitialSize == this.codePoint2Entity.size()) {
                        throw new StopParsingException();
                    }
                }
                this.stage = (byte)3;
            } else if (this.stage == 11) {
                try {
                    InputSource inputSource = EntityFinder.this.resolver.resolveEntity(null, charSequence.toString());
                    if (inputSource != null) {
                        this.mapCount += EntityFinder.this.findEntities(this.codePoint2Entity, inputSource.getCharacterStream());
                        if (this.mapCount + this.mapInitialSize == this.codePoint2Entity.size()) {
                            throw new StopParsingException();
                        }
                    }
                }
                catch (IOException | SAXException exception) {
                    // empty catch block
                }
                this.stage = 0;
            }
        }

        public void quotedWithControl(int n, CharSequence charSequence, int n2) {
        }

        public void quotedNewlineChar(int n, int n2) {
        }

        public void openGroup(int n, int n2) {
            this.stage = (byte)-1;
        }

        public void closeGroup(int n, int n2) {
            this.stage = (byte)-1;
        }

        public void character(int n, int n2) {
            if (n2 == 62) {
                this.stage = 0;
            } else if (n2 == 37 && this.stage == 1) {
                this.stage = (byte)10;
            }
        }

        public void escaped(int n, int n2) {
        }

        public void control(int n, int n2) {
        }

        public void commented(int n, int n2, String string) {
        }

        public void endOfStream(int n) {
        }

        public void error(int n, byte by, CharSequence charSequence) {
        }
    }

    private static class StopParsingException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        StopParsingException() {
        }
    }
}

