/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.script;

import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.script.ImportInfo;
import io.sf.carte.echosvg.script.Interpreter;
import io.sf.carte.echosvg.script.InterpreterFactory;
import io.sf.carte.echosvg.script.SecurityHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.w3c.dom.Document;

public class InterpreterPool {
    public static final String BIND_NAME_DOCUMENT = "document";
    protected static Map<String, InterpreterFactory> defaultFactories = new HashMap<String, InterpreterFactory>(7);
    protected Map<String, InterpreterFactory> factories = new HashMap<String, InterpreterFactory>(7);

    public InterpreterPool() {
        this.factories.putAll(defaultFactories);
    }

    public Interpreter createInterpreter(Document document, String string) {
        return this.createInterpreter(document, string, null);
    }

    public Interpreter createInterpreter(Document document, String string, ImportInfo importInfo) {
        InterpreterFactory interpreterFactory = this.factories.get(string);
        if (interpreterFactory == null) {
            return null;
        }
        if (importInfo == null) {
            importInfo = ImportInfo.getImports();
        }
        Interpreter interpreter = null;
        SVGOMDocument sVGOMDocument = (SVGOMDocument)document;
        URL uRL = null;
        try {
            uRL = new URL(sVGOMDocument.getDocumentURI());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        interpreter = InterpreterPool.createInterpreter(interpreterFactory, uRL, sVGOMDocument.isSVG12(), importInfo);
        if (interpreter == null) {
            return null;
        }
        interpreter.bindObject(BIND_NAME_DOCUMENT, document);
        return interpreter;
    }

    private static Interpreter createInterpreter(final InterpreterFactory interpreterFactory, final URL uRL, final boolean bl, final ImportInfo importInfo) {
        PrivilegedExceptionAction<Interpreter> privilegedExceptionAction = new PrivilegedExceptionAction<Interpreter>(){

            @Override
            public Interpreter run() throws Exception {
                return interpreterFactory.createInterpreter(uRL, bl, importInfo);
            }
        };
        try {
            return (Interpreter)SecurityHelper.getInstance().runPrivilegedExceptionAction(privilegedExceptionAction);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            exception.printStackTrace();
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void putInterpreterFactory(String string, InterpreterFactory interpreterFactory) {
        this.factories.put(string, interpreterFactory);
    }

    public void removeInterpreterFactory(String string) {
        this.factories.remove(string);
    }

    static {
        ServiceLoader<InterpreterFactory> serviceLoader = ServiceLoader.load(InterpreterFactory.class);
        Iterator<InterpreterFactory> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            String[] stringArray;
            InterpreterFactory interpreterFactory = null;
            interpreterFactory = iterator.next();
            for (String string : stringArray = interpreterFactory.getMimeTypes()) {
                defaultFactories.put(string, interpreterFactory);
            }
        }
    }
}

