/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.style.css.MediaQueryList;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;

class StyleDefinerElementHelper {
    private final DOMElement element;
    private AbstractCSSStyleSheet definedSheet = null;
    private boolean needsUpdate = true;

    StyleDefinerElementHelper(DOMElement dOMElement) {
        this.element = dOMElement;
    }

    AbstractCSSStyleSheet getInlineSheet() {
        if (this.needsUpdate) {
            String string = this.element.getAttribute("type");
            if (!"text/css".equalsIgnoreCase(string) && string.length() != 0) {
                return null;
            }
            MediaQueryList mediaQueryList = this.element.getOwnerDocument().parseMediaList(this.element.getAttribute("media").trim(), this.element);
            if (mediaQueryList == null) {
                return null;
            }
            String string2 = this.element.getAttribute("title").trim();
            if (string2.length() == 0) {
                string2 = null;
            }
            String string3 = this.element.getTextContent().trim();
            this.definedSheet = this.element.getOwnerDocument().parseEmbeddedStyleSheet(this.definedSheet, string3, string2, mediaQueryList, this.element);
            this.needsUpdate = false;
        }
        return this.definedSheet;
    }

    AbstractCSSStyleSheet getLinkedSheet() {
        if (this.needsUpdate) {
            String string = this.element.getAttribute("rel");
            String string2 = this.element.getAttribute("type");
            int n = string2.length();
            if (n == 0 ? string.length() == 0 : !"text/css".equalsIgnoreCase(string2)) {
                return null;
            }
            byte by = AbstractCSSStyleSheet.parseRelAttribute(string);
            if (by != -1) {
                String string3;
                String string4 = this.element.getAttribute("title").trim();
                if (string4.length() == 0) {
                    string4 = null;
                }
                if ((string3 = this.element.getAttribute("href")).length() != 0) {
                    if (by == 0) {
                        if (this.loadLinkedStyleSheet(string3, string4)) {
                            this.needsUpdate = false;
                        }
                    } else if (string4 != null) {
                        if (string3.length() != 0) {
                            boolean bl;
                            boolean bl2 = bl = this.definedSheet == null || !string4.equalsIgnoreCase(this.element.getOwnerDocument().getSelectedStyleSheetSet());
                            if (this.loadLinkedStyleSheet(string3, string4)) {
                                if (bl) {
                                    this.definedSheet.setDisabled(true);
                                }
                                this.needsUpdate = false;
                            }
                        }
                    } else {
                        this.element.getOwnerDocument().getErrorHandler().linkedStyleError(this.element, "Alternate sheet without title");
                    }
                } else {
                    this.element.getOwnerDocument().getErrorHandler().linkedStyleError(this.element, "Missing or void href attribute.");
                }
            } else {
                this.definedSheet = null;
            }
        }
        return this.definedSheet;
    }

    private boolean loadLinkedStyleSheet(String string, String string2) {
        MediaQueryList mediaQueryList = this.element.getOwnerDocument().parseMediaList(this.element.getAttribute("media").trim(), this.element);
        if (mediaQueryList == null) {
            this.definedSheet = null;
            return false;
        }
        this.definedSheet = this.element.getOwnerDocument().loadStyleSheet(this.definedSheet, string, string2, mediaQueryList, this.element);
        return true;
    }

    void resetSheet() {
        AbstractCSSStyleSheet abstractCSSStyleSheet = this.definedSheet;
        if (abstractCSSStyleSheet != null) {
            abstractCSSStyleSheet.getCssRules().clear();
        }
        this.needsUpdate = true;
        this.element.getOwnerDocument().onSheetModify();
    }

    void postAddChildInline(AbstractDOMNode abstractDOMNode) {
        if (this.element.getFirstChild().getNextSibling() != null) {
            this.resetSheet();
            this.getInlineSheet();
        }
    }

    boolean containsCSS() {
        AbstractCSSStyleSheet abstractCSSStyleSheet;
        String string;
        return this.definedSheet != null && ("text/css".equalsIgnoreCase(string = this.element.getAttribute("type")) || string.length() == 0 && (abstractCSSStyleSheet = this.getInlineSheet()) != null && abstractCSSStyleSheet.getCssRules().getLength() != 0);
    }
}

