/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.bridge;

import io.sf.carte.echosvg.bridge.AbstractSVGFilterPrimitiveElementBridge;
import io.sf.carte.echosvg.bridge.BridgeContext;
import io.sf.carte.echosvg.bridge.BridgeException;
import io.sf.carte.echosvg.bridge.SVGUtilities;
import io.sf.carte.echosvg.ext.awt.image.PadMode;
import io.sf.carte.echosvg.ext.awt.image.renderable.ConvolveMatrixRable8Bit;
import io.sf.carte.echosvg.ext.awt.image.renderable.Filter;
import io.sf.carte.echosvg.ext.awt.image.renderable.PadRable8Bit;
import io.sf.carte.echosvg.gvt.GraphicsNode;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.awt.image.Kernel;
import java.util.Map;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class SVGFeConvolveMatrixElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feConvolveMatrix";
    }

    @Override
    public Filter createFilter(BridgeContext bridgeContext, Element element, Element element2, GraphicsNode graphicsNode, Filter filter, Rectangle2D rectangle2D, Map<String, Filter> map) {
        int[] nArray = SVGFeConvolveMatrixElementBridge.convertOrder(element, bridgeContext);
        float[] fArray = SVGFeConvolveMatrixElementBridge.convertKernelMatrix(element, nArray, bridgeContext);
        float f = SVGFeConvolveMatrixElementBridge.convertDivisor(element, fArray, bridgeContext);
        float f2 = SVGFeConvolveMatrixElementBridge.convertNumber(element, "bias", 0.0f, bridgeContext);
        int[] nArray2 = SVGFeConvolveMatrixElementBridge.convertTarget(element, nArray, bridgeContext);
        PadMode padMode = SVGFeConvolveMatrixElementBridge.convertEdgeMode(element, bridgeContext);
        double[] dArray = SVGFeConvolveMatrixElementBridge.convertKernelUnitLength(element, bridgeContext);
        boolean bl = SVGFeConvolveMatrixElementBridge.convertPreserveAlpha(element, bridgeContext);
        Filter filter2 = SVGFeConvolveMatrixElementBridge.getIn(element, element2, graphicsNode, filter, map, bridgeContext);
        if (filter2 == null) {
            return null;
        }
        Rectangle2D rectangle2D2 = filter2.getBounds2D();
        Rectangle2D rectangle2D3 = SVGUtilities.convertFilterPrimitiveRegion(element, element2, graphicsNode, rectangle2D2, rectangle2D, bridgeContext);
        PadRable8Bit padRable8Bit = new PadRable8Bit(filter2, rectangle2D3, PadMode.ZERO_PAD);
        ConvolveMatrixRable8Bit convolveMatrixRable8Bit = new ConvolveMatrixRable8Bit((Filter)padRable8Bit);
        int n = 0;
        while (n < fArray.length) {
            int n2 = n++;
            fArray[n2] = fArray[n2] / f;
        }
        convolveMatrixRable8Bit.setKernel(new Kernel(nArray[0], nArray[1], fArray));
        convolveMatrixRable8Bit.setTarget(new Point(nArray2[0], nArray2[1]));
        convolveMatrixRable8Bit.setBias((double)f2);
        convolveMatrixRable8Bit.setEdgeMode(padMode);
        convolveMatrixRable8Bit.setKernelUnitLength(dArray);
        convolveMatrixRable8Bit.setPreserveAlpha(bl);
        SVGFeConvolveMatrixElementBridge.handleColorInterpolationFilters((Filter)convolveMatrixRable8Bit, element);
        PadRable8Bit padRable8Bit2 = new PadRable8Bit((Filter)convolveMatrixRable8Bit, rectangle2D3, PadMode.ZERO_PAD);
        SVGFeConvolveMatrixElementBridge.updateFilterMap(element, (Filter)padRable8Bit2, map);
        return padRable8Bit2;
    }

    protected static int[] convertOrder(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "order");
        if (string.isEmpty()) {
            return new int[]{3, 3};
        }
        int[] nArray = new int[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            nArray[0] = SVGUtilities.convertSVGInteger(stringTokenizer.nextToken());
            nArray[1] = stringTokenizer.hasMoreTokens() ? SVGUtilities.convertSVGInteger(stringTokenizer.nextToken()) : nArray[0];
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"order", string, numberFormatException});
        }
        if (stringTokenizer.hasMoreTokens() || nArray[0] <= 0 || nArray[1] <= 0) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"order", string});
        }
        return nArray;
    }

    protected static float[] convertKernelMatrix(Element element, int[] nArray, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "kernelMatrix");
        if (string.isEmpty()) {
            throw new BridgeException(bridgeContext, element, "attribute.missing", new Object[]{"kernelMatrix"});
        }
        int n = nArray[0] * nArray[1];
        float[] fArray = new float[n];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        int n2 = 0;
        try {
            while (stringTokenizer.hasMoreTokens() && n2 < n) {
                fArray[n2++] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"kernelMatrix", string, numberFormatException});
        }
        if (n2 != n) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"kernelMatrix", string});
        }
        return fArray;
    }

    protected static float convertDivisor(Element element, float[] fArray, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "divisor");
        if (string.isEmpty()) {
            float f = 0.0f;
            for (float f2 : fArray) {
                f += f2;
            }
            return f == 0.0f ? 1.0f : f;
        }
        try {
            return SVGUtilities.convertSVGNumber(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"divisor", string, numberFormatException});
        }
    }

    protected static int[] convertTarget(Element element, int[] nArray, BridgeContext bridgeContext) {
        int n;
        int[] nArray2 = new int[2];
        String string = element.getAttributeNS(null, "targetX");
        if (string.isEmpty()) {
            nArray2[0] = nArray[0] / 2;
        } else {
            try {
                n = SVGUtilities.convertSVGInteger(string);
                if (n < 0 || n >= nArray[0]) {
                    throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"targetX", string});
                }
                nArray2[0] = n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"targetX", string, numberFormatException});
            }
        }
        string = element.getAttributeNS(null, "targetY");
        if (string.isEmpty()) {
            nArray2[1] = nArray[1] / 2;
        } else {
            try {
                n = SVGUtilities.convertSVGInteger(string);
                if (n < 0 || n >= nArray[1]) {
                    throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"targetY", string});
                }
                nArray2[1] = n;
            }
            catch (NumberFormatException numberFormatException) {
                throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"targetY", string, numberFormatException});
            }
        }
        return nArray2;
    }

    protected static double[] convertKernelUnitLength(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "kernelUnitLength");
        if (string.isEmpty()) {
            return null;
        }
        double[] dArray = new double[2];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        try {
            dArray[0] = SVGUtilities.convertSVGNumber(stringTokenizer.nextToken());
            dArray[1] = stringTokenizer.hasMoreTokens() ? (double)SVGUtilities.convertSVGNumber(stringTokenizer.nextToken()) : dArray[0];
        }
        catch (NumberFormatException numberFormatException) {
            throw new BridgeException(bridgeContext, element, numberFormatException, "attribute.malformed", new Object[]{"kernelUnitLength", string});
        }
        if (stringTokenizer.hasMoreTokens() || dArray[0] <= 0.0 || dArray[1] <= 0.0) {
            throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"kernelUnitLength", string});
        }
        return dArray;
    }

    protected static PadMode convertEdgeMode(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "edgeMode");
        if (string.isEmpty() || "duplicate".equals(string)) {
            return PadMode.REPLICATE;
        }
        if ("wrap".equals(string)) {
            return PadMode.WRAP;
        }
        if ("none".equals(string)) {
            return PadMode.ZERO_PAD;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"edgeMode", string});
    }

    protected static boolean convertPreserveAlpha(Element element, BridgeContext bridgeContext) {
        String string = element.getAttributeNS(null, "preserveAlpha");
        if (string.isEmpty()) {
            return false;
        }
        if ("true".equals(string)) {
            return true;
        }
        if ("false".equals(string)) {
            return false;
        }
        throw new BridgeException(bridgeContext, element, "attribute.malformed", new Object[]{"preserveAlpha", string});
    }
}

