/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;

public class GlyfCompositeComp {
    private static final short ARG_1_AND_2_ARE_WORDS = 1;
    private static final short ARGS_ARE_XY_VALUES = 2;
    public static final short ROUND_XY_TO_GRID = 4;
    private static final short WE_HAVE_A_SCALE = 8;
    public static final short MORE_COMPONENTS = 32;
    private static final short WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private static final short WE_HAVE_A_TWO_BY_TWO = 128;
    public static final short WE_HAVE_INSTRUCTIONS = 256;
    public static final short USE_MY_METRICS = 512;
    private final int _firstIndex;
    private final int _firstContour;
    private short _argument1;
    private short _argument2;
    private int _flags;
    private int _glyphIndex;
    private double _xscale = 1.0;
    private double _yscale = 1.0;
    private double _scale01 = 0.0;
    private double _scale10 = 0.0;
    private int _xtranslate = 0;
    private int _ytranslate = 0;
    private int _point1 = 0;
    private int _point2 = 0;

    GlyfCompositeComp(int n, int n2, DataInput dataInput) throws IOException {
        this._firstIndex = n;
        this._firstContour = n2;
        this._flags = dataInput.readUnsignedShort();
        this._glyphIndex = dataInput.readUnsignedShort();
        if ((this._flags & 1) != 0) {
            this._argument1 = dataInput.readShort();
            this._argument2 = dataInput.readShort();
        } else {
            this._argument1 = dataInput.readByte();
            this._argument2 = dataInput.readByte();
        }
        if ((this._flags & 2) != 0) {
            this._xtranslate = this._argument1;
            this._ytranslate = this._argument2;
        } else {
            this._point1 = this._argument1;
            this._point2 = this._argument2;
        }
        if ((this._flags & 8) != 0) {
            short s = dataInput.readShort();
            this._xscale = this._yscale = (double)s / 16384.0;
        } else if ((this._flags & 0x40) != 0) {
            short s = dataInput.readShort();
            this._xscale = (double)s / 16384.0;
            s = dataInput.readShort();
            this._yscale = (double)s / 16384.0;
        } else if ((this._flags & 0x80) != 0) {
            short s = dataInput.readShort();
            this._xscale = (double)s / 16384.0;
            s = dataInput.readShort();
            this._scale01 = (double)s / 16384.0;
            s = dataInput.readShort();
            this._scale10 = (double)s / 16384.0;
            s = dataInput.readShort();
            this._yscale = (double)s / 16384.0;
        }
    }

    public int getFirstIndex() {
        return this._firstIndex;
    }

    public int getFirstContour() {
        return this._firstContour;
    }

    public short getArgument1() {
        return this._argument1;
    }

    public short getArgument2() {
        return this._argument2;
    }

    public int getFlags() {
        return this._flags;
    }

    public int getGlyphIndex() {
        return this._glyphIndex;
    }

    public double getScale01() {
        return this._scale01;
    }

    public double getScale10() {
        return this._scale10;
    }

    public double getXScale() {
        return this._xscale;
    }

    public double getYScale() {
        return this._yscale;
    }

    public int getXTranslate() {
        return this._xtranslate;
    }

    public int getYTranslate() {
        return this._ytranslate;
    }

    public int scaleX(int n, int n2) {
        return (int)((double)n * this._xscale + (double)n2 * this._scale10);
    }

    public int scaleY(int n, int n2) {
        return (int)((double)n * this._scale01 + (double)n2 * this._yscale);
    }
}

