/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.graph.ui.shapes;

import com.jogamp.graph.curve.OutlineShape;
import com.jogamp.graph.curve.opengl.TextRegionUtil;
import com.jogamp.graph.font.Font;
import com.jogamp.graph.geom.plane.AffineTransform;
import com.jogamp.graph.ui.GraphShape;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.math.geom.AABBox;

public class Label
extends GraphShape {
    private Font font;
    private float fontScale;
    private String text;
    private final AffineTransform tempT1 = new AffineTransform();
    private final AffineTransform tempT2 = new AffineTransform();
    private final AffineTransform tempT3 = new AffineTransform();
    private final Font.GlyphVisitor glyphVisitor = new Font.GlyphVisitor(){

        @Override
        public void visit(char c, Font.Glyph glyph, AffineTransform affineTransform) {
            if (glyph.isWhiteSpace()) {
                return;
            }
            OutlineShape outlineShape = glyph.getShape();
            outlineShape.setSharpness(Label.this.oshapeSharpness);
            Label.this.region.addOutlineShape(outlineShape, affineTransform, Label.this.rgbaColor);
        }
    };

    public Label(int n, Font font, float f, String string) {
        super(n);
        this.font = font;
        this.fontScale = f;
        this.text = string;
    }

    public Label(int n, Font font, String string) {
        super(n);
        this.font = font;
        this.fontScale = 1.0f;
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public boolean setText(String string) {
        if (!this.text.equals(string)) {
            this.text = string;
            this.markShapeDirty();
            return true;
        }
        return false;
    }

    public boolean setText(GL2ES2 gL2ES2, String string) {
        if (this.setText(string)) {
            this.validate(gL2ES2);
            return true;
        }
        return false;
    }

    public boolean setText(GLProfile gLProfile, String string) {
        if (this.setText(string)) {
            this.validate(gLProfile);
            return true;
        }
        return false;
    }

    public Font getFont() {
        return this.font;
    }

    public boolean setFont(Font font) {
        if (!this.font.equals(font)) {
            this.font = font;
            this.markShapeDirty();
            return true;
        }
        return false;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public float getLineHeight() {
        return this.fontScale * this.font.getLineHeight();
    }

    public float getScaledLineHeight() {
        return this.getScale().y() * this.fontScale * this.font.getLineHeight();
    }

    public boolean setFontScale(float f) {
        if (this.fontScale != f) {
            this.fontScale = f;
            this.markShapeDirty();
            return true;
        }
        return false;
    }

    @Override
    protected void addShapeToRegion(GLProfile gLProfile, GL2ES2 gL2ES2) {
        int[] nArray = TextRegionUtil.countStringRegion(this.font, this.text, new int[2]);
        this.resetGLRegion(gLProfile, gL2ES2, null, nArray[0], nArray[1]);
        AABBox aABBox = this.font.getGlyphBounds(this.text, this.tempT2, this.tempT3);
        this.tempT1.setToScale(this.fontScale, this.fontScale);
        this.tempT1.translate(-aABBox.getMinX(), -aABBox.getMinY(), this.tempT2);
        aABBox = this.font.processString(this.glyphVisitor, this.tempT1, this.text, this.tempT2, this.tempT3);
        this.setRotationPivot(aABBox.getCenter());
        this.box.copy(aABBox);
    }

    @Override
    public String getSubString() {
        int n = Math.min(this.text.length(), 8);
        return super.getSubString() + ", fscale " + this.fontScale + ", '" + this.text.substring(0, n) + "'";
    }
}

