/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery.predicates;

import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.ModifierSupport;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.0")
public class IsPotentialTestContainer
implements Predicate<Class<?>> {
    @Override
    public boolean test(Class<?> candidate) {
        if (ModifierSupport.isPrivate(candidate)) {
            return false;
        }
        if (ModifierSupport.isAbstract(candidate)) {
            return false;
        }
        if (candidate.isLocalClass()) {
            return false;
        }
        if (candidate.isAnonymousClass()) {
            return false;
        }
        return !ReflectionUtils.isInnerClass(candidate);
    }
}

