/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.AccelerateableAction;
import org.freeplane.core.ui.LabelAndMnemonicSetter;
import org.freeplane.core.util.TextUtils;

public class SetFKeyAcceleratorOnNextClickAction
extends AbstractAction {
    private static final String IGNORE_UNASSIGNED_F_KEYS = "ignore_unassigned_f_keys";
    private static final long serialVersionUID = 1L;
    private final KeyStroke accelerator;

    public SetFKeyAcceleratorOnNextClickAction(KeyStroke accelerator) {
        this.accelerator = accelerator;
        this.setEnabled();
        ResourceController.getResourceController().addPropertyChangeListener(new IFreeplanePropertyListener(){

            @Override
            public void propertyChanged(String propertyName, String newValue, String oldValue) {
                if (propertyName.equals(SetFKeyAcceleratorOnNextClickAction.IGNORE_UNASSIGNED_F_KEYS)) {
                    SetFKeyAcceleratorOnNextClickAction.this.setEnabled();
                }
            }
        });
    }

    private void setEnabled() {
        boolean enabled = !ResourceController.getResourceController().getBooleanProperty(IGNORE_UNASSIGNED_F_KEYS);
        this.setEnabled(enabled);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (ResourceController.getResourceController().getBooleanProperty(IGNORE_UNASSIGNED_F_KEYS)) {
            return;
        }
        AccelerateableAction.setNewAcceleratorOnNextClick(this.accelerator);
        JCheckBox dontShowAgainBox = new JCheckBox(TextUtils.getRawText("OptionalDontShowMeAgainDialog.dontShowAgain"));
        final JDialog acceleratorOnNextClickActionDialog = AccelerateableAction.getAcceleratorOnNextClickActionDialog();
        acceleratorOnNextClickActionDialog.getContentPane().add((Component)dontShowAgainBox, "South");
        acceleratorOnNextClickActionDialog.pack();
        dontShowAgainBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResourceController.getResourceController().setProperty(SetFKeyAcceleratorOnNextClickAction.IGNORE_UNASSIGNED_F_KEYS, true);
                acceleratorOnNextClickActionDialog.setVisible(false);
            }
        });
        LabelAndMnemonicSetter.setLabelAndMnemonic(dontShowAgainBox, null);
    }
}

