/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import org.freeplane.api.Dash;
import org.freeplane.features.nodestyle.NodeGeometryModel;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.ShapedPainter;

class RectanglePainter
extends ShapedPainter {
    RectanglePainter(MainView mainView, NodeGeometryModel shapeConfiguration) {
        super(mainView, shapeConfiguration);
    }

    @Override
    void paintNodeShape(Graphics2D g) {
        int zoomedEdgeWidth = this.mainView.getPaintedBorderWidth();
        g.drawRect(zoomedEdgeWidth / 2, zoomedEdgeWidth / 2, this.mainView.getWidth() - zoomedEdgeWidth, this.mainView.getHeight() - zoomedEdgeWidth);
    }

    @Override
    void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        int borderWidth = this.mainView.getPaintedBorderWidth();
        int overlapWidth = this.mainView.getDash() == Dash.SOLID ? 1 : 0;
        graphics.fillRect(borderWidth, borderWidth, this.mainView.getWidth() - 2 * borderWidth + overlapWidth, this.mainView.getHeight() - 2 * borderWidth + overlapWidth);
    }

    @Override
    Insets getInsets() {
        int borderWidthInset = (int)(this.mainView.getUnzoomedBorderWidth() - 1.0f);
        NodeGeometryModel shapeConfiguration = this.getShapeConfiguration();
        int horizontalMargin = shapeConfiguration.getHorizontalMargin().toBaseUnitsRounded() + borderWidthInset;
        int verticalMargin = shapeConfiguration.getVerticalMargin().toBaseUnitsRounded() + borderWidthInset;
        return new Insets(verticalMargin, horizontalMargin, verticalMargin, horizontalMargin);
    }

    @Override
    Insets getInsets(Insets insets) {
        return this.getInsets();
    }

    @Override
    Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.mainView.isPreferredSizeSet()) {
            return preferredSize;
        }
        preferredSize.width = this.mainView.limitWidth(preferredSize.width, this.mainView.getPaintedBorderWidth());
        if (this.getShapeConfiguration().isUniform()) {
            if (preferredSize.width < preferredSize.height) {
                preferredSize.width = preferredSize.height;
            } else {
                preferredSize.height = preferredSize.width;
            }
        }
        return preferredSize;
    }
}

