#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-5cGYVAS4P4T8xEXkEYunis
key:                  dhall-1.42.3-5cGYVAS4P4T8xEXkEYunis
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  07f513d060caea298c3651c646fb8b28
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-5cGYVAS4P4T8xEXkEYunis
depends:
    Diff-0.5-2WBqMHHuMKKJPXXpUwfTmb
    aeson-2.1.2.1-IZ8jLcnEISD7S5Vyf2Tehm
    aeson-pretty-0.8.10-7AZJj9bF88Xg9Byh4QeA2
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU
    atomic-write-0.2.1.1-CTvCjED2WnfHIHbZGmsgWL base-4.17.2.1
    base16-bytestring-1.0.2.0-62vCRO27GtdAcMEJSD5omm
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-3FuXchFPXBfLVJKu7fam1O
    cborg-0.2.10.0-JX1WquWtI7t5WQ9eeXW5fl
    cborg-json-0.2.6.0-3cEGKPtVTA3JdCJAJwNjYN containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-EqGNSDpeFglF4wtTrNd7qj
    data-fix-0.3.4-1oDV29qiF3YBr3NVTbnbqA deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-GCeYud6YZTH1jjBgRKWFzJ exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-C1a9Qbp4xbQ1o7PMINXehQ
    hashable-1.4.5.0-FhpNKvHQsJeLXuGJFx8piW haskeline-0.8.2
    http-client-0.7.19-B8l1xqF9CzrAQJibWsxIAb
    http-client-tls-0.3.6.4-Egz0XoSYeB1LT6UCJVMaX8
    http-types-0.12.4-9GhteoJuOlZ3ATAYoIbhkU
    indexed-traversable-0.1.4-SYv5547dJK2gDTDCEMijk
    megaparsec-9.7.0-EujlCtvd6hmm53pqN4SFa
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-BPG1Yj05GAIIauIotQ4jTb
    optparse-applicative-0.18.1.0-BfpmqtzGsjUFBu8SCUDd7D
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-WOoOMW4mfrJS8mGJE0DEQ
    pretty-simple-4.1.3.0-5b0snePE1mm42Z9rumxIIV
    prettyprinter-1.7.1-1kfTx5RMvNJHRpCjVrY3F5
    prettyprinter-ansi-terminal-1.1.3-8ZkLYQp310e9tsa1KLQyqJ
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-JtTPeMck4RoCJw8PpYbrMQ
    serialise-0.2.6.1-QP3DEokprTEmrS2g23Pda template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-72AV97LlqgpB49EazUFi35
    text-short-0.1.6-Eu53Zq5IEYR7y41LFWcVVu
    th-lift-instances-0.1.20-GfefalysHn4FCLZ05DloDG time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-FHEkyK2HAgOIviNihEwrGS
    unordered-containers-0.2.20-79maJZZuZDu8bRI1CHuoJG
    vector-0.13.2.0-9TreTxHfwqF7cSCfMWPj9u

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

