#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.3
visibility:           public
id:                   dhall-1.42.3-GUQQ9vOMXIYAOCPwnqK0Bb
key:                  dhall-1.42.3-GUQQ9vOMXIYAOCPwnqK0Bb
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  c6249a342c1b397166d5ecb3f2a2852b
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.3-GUQQ9vOMXIYAOCPwnqK0Bb
depends:
    Diff-0.5-CFajIZ8dkNLBAcT1NAzb1Z
    aeson-2.1.2.1-AErwMfn2r5g1Pc6FekWoJb
    aeson-pretty-0.8.10-HGqdLPRnyeEEY0lM8KqhKG
    ansi-terminal-1.0.2-Bnl76ueL4Li3NnUVLDNwn4
    atomic-write-0.2.1.1-BLD3trT2ppiCxu7GyF43wr base-4.17.2.1
    base16-bytestring-1.0.2.0-20IAHeb4Utp2ZGQEDCbDdS
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-AMgBCf5fDYf4pbGdLaLtss
    cborg-0.2.10.0-HHXtzuFvrYgLdZkal3DgYf
    cborg-json-0.2.6.0-2kjJ6J4EIDD4QaGdjHoHCq containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-I0nEVOTgw9x45ad0ZDS9m
    data-fix-0.3.4-IJb76nVl3OuDqhFu4FpFxk deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-KZxQ1sg7XnkCEJj7wMAPBx exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-J7WZLCjxo3r55zKzuusiLE
    hashable-1.4.6.0-HNsjIjcKtfz4EPsBV3Crzv haskeline-0.8.2
    http-client-0.7.19-4UbGlDhlNmJ9JhWVX5eNPs
    http-client-tls-0.3.6.4-AVJGLtBIuZakSDpEPaS0o
    http-types-0.12.4-8EgajALSM5xB8GFkN9ClFd
    indexed-traversable-0.1.4-LEIrmfAgnpb6NsyAYoysCc
    megaparsec-9.7.0-ATzV0kIhS1c1WF6GxcAl4n
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-mtl-0.2.1.0-LWyutRK1cqlCk2SYzoFhAy
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-Db65q7JXyy8EWWIZuTCsbL
    optparse-applicative-0.18.1.0-4C3xA04o7PTLcTJxkr1Svw
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-JgEvWL84uirF9ZC5kawQtq
    pretty-simple-4.1.3.0-KgcQs0J4cPmLd16Hi3h6pi
    prettyprinter-1.7.1-KHTd6ELn8JD9j39b7JIrXU
    prettyprinter-ansi-terminal-1.1.3-1UfbVX11m0EFNFdqWdhwHG
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-Hcx0Ig8vfV6K9QIlykOJmr
    serialise-0.2.6.1-2yLw2oqJJD1dclq3sJo4a template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-9PrVNZM2KyiLGsFByyJQ50
    text-short-0.1.6-5kPxdQsPv791E9LIzAETZ5
    th-lift-instances-0.1.20-CYhiJ3i5DpkK2BDKNeSUGg time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-DzNkTFZTZy3DoMPfVsxmLG
    unordered-containers-0.2.20-2t1vPVJZrFoJrApu3o7oBM
    vector-0.13.2.0-ALyKXv7XVpOIl9EVBdgwIc

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

