#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-IiW9SAOWYVl82rnAFSa5PF
key:                  dhall-1.42.2-IiW9SAOWYVl82rnAFSa5PF
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  4236d961507944eef043a0dd480bfcd3
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-IiW9SAOWYVl82rnAFSa5PF
depends:
    Diff-0.5-GzUbzmeQvoG8gRPGshhW48
    aeson-2.1.2.1-GhEX0nU3rpe2rpNz8TrqEz
    aeson-pretty-0.8.10-7l5sgzPY9hGETafg7PWfDa
    ansi-terminal-1.0.2-EIBfHgisaKe3sxxvXB2j6n
    atomic-write-0.2.1.1-1no5HFWQQAJAbS3cGenxHq base-4.17.2.1
    base16-bytestring-1.0.2.0-F3bh2T1ogzY4kBMIvDiuUI
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-4S8KsHm7tqa4BSXUqBqEFP
    cborg-0.2.10.0-EBtvuZN52ChH9L5SJKn5cz
    cborg-json-0.2.6.0-EfwyJP2014hDfS4iDpIm7y containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-3FoCgzjVrYcBQH5XXJrcGn
    data-fix-0.3.4-2JmTWGVlfn1Dx25eNDpOfJ deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-HI4XU92GWuzAurkLHewkeW exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-8gksQmhaaEPIB8A3oYGdTg
    hashable-1.4.4.0-GXwYNb6ixbL0AOxKKxOK7 haskeline-0.8.2
    http-client-0.7.19-2gxWIBw6DZOLOrOirSGCjs
    http-client-tls-0.3.6.4-ASsMA44245pH60llfmtwLM
    http-types-0.12.4-8AFNw5oQ8TE9V2A9rZjrTr
    indexed-traversable-0.1.4-IdrLHXCvQGN9TboScqmWoy
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-4uCmo2rz8QPI88LtUBVGYi
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-E36L5Munrgj3tkxSsgYpcw
    optparse-applicative-0.18.1.0-LIQoJoN7TQpDnAr18DZx9V
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-Ky7ZRiefyAHHQ5Wfdt1qDj
    pretty-simple-4.1.3.0-77hus1OtdNsBGgGpZ26GGF
    prettyprinter-1.7.1-Hi17Zu3O6FiIO5eybHbcRR
    prettyprinter-ansi-terminal-1.1.3-1sT1NT5hMp2CeTvXMcpM3w
    profunctors-5.6.3-CEP6cqubzZKKWW4LuwSiua
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-IWovBluCcknEjldn22iWzh
    serialise-0.2.6.1-7T31yFWsOe99tV2dR7WrKF template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-1EpBHwbps8s71fZDRLQwfh
    text-short-0.1.6-DYsQc8gAFXc15ZZAqS83Cn
    th-lift-instances-0.1.20-6P4OQ9A4i7wIGZk3PkSooe time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-HG505sH2B9u2NzkBqafBkg
    unordered-containers-0.2.20-psp1ib8v1R5J9F619BTWH
    vector-0.13.2.0-BxFNQQxQb2S1T9ycXEZ0Cs

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

