#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-HAiXGdbqkvQ3BoJ7aEbOw4
key:                  dhall-1.42.2-HAiXGdbqkvQ3BoJ7aEbOw4
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  bfafca08233ec3529632e4254232317d
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-HAiXGdbqkvQ3BoJ7aEbOw4
depends:
    Diff-0.5-LkgmmzaMBc4fYApDG2qCq aeson-2.1.2.1-AuEsVg6Hhe2CPhaLp40FYe
    aeson-pretty-0.8.10-KZ76PN7XcX2AgbJNY8mCT3
    ansi-terminal-1.0.2-FTkVGNDxEfy5jKOkYDwQmU
    atomic-write-0.2.1.1-CFb64fe0b0U7uhlkjbL2Me base-4.17.2.1
    base16-bytestring-1.0.2.0-FFyoh3BEwBDECdSU16X13M
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-FtXwbgcyUdT58mvaxnolJS
    cborg-0.2.10.0-Jf3cZhZrkCQBLW1k6GxVjS
    cborg-json-0.2.6.0-GT4sWBdfgQsBvXyG3n262l containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-8LQfVNr8vHkIZIEXTE1vSD
    data-fix-0.3.4-8xjVN4giadiIbkbvusQKNY deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-8CcsCVCVsaj6zvyvBmbMda exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-HjjHFRV9KSY1I0jF7Mrw4D
    hashable-1.4.4.0-Htybuq5UDQvAvffgJDQoKe haskeline-0.8.2
    http-client-0.7.19-veq4MTHniy21v9pOYpRdd
    http-client-tls-0.3.6.4-BtAmNja0oKIEdL14Ub64ie
    http-types-0.12.4-KxfEKIoLDdBKlrGUyHct4y
    indexed-traversable-0.1.4-FCsG1ap1yHZHMY7IKzng2H
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-B43tSYbC6tf2tuA1FPKzy1
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-BuPsn3YVnowHuszetfOccY
    optparse-applicative-0.18.1.0-79DXPPhnqn915zrePmz04b
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-KoAUVrAe7crFLX2YZ2HXgQ
    pretty-simple-4.1.3.0-20w9LYXL6UaIDeJtvEXr16
    prettyprinter-1.7.1-CmtY07bno6e3Q2mVZUKdcs
    prettyprinter-ansi-terminal-1.1.3-JS9wKzbNroOFRAFDlKaDBF
    profunctors-5.6.3-IK4aKRu9MWh3uNvR52YaRo
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-LCs3zqD3ZVT6NyF8Z7YnMi
    serialise-0.2.6.1-GC0bkAE0Zh5HVNe2I3cqMP template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-1ELyLITwHPCA1JrwojBxjS
    text-short-0.1.6-ESbVeZaQFVYIvhZSjtILRt
    th-lift-instances-0.1.20-IdQb3FyUpwaJTkICUUBA3m time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-CuldQnaf1nH9gOZ1eDmEZL
    unordered-containers-0.2.20-FOY8P5Y3sqjANbVUEJi9Vi
    vector-0.13.2.0-6oLw41loWTIuQEg8iaHmr

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

