#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-5eJjyz4uxgp78NhDmmbxEk
key:                  dhall-1.42.2-5eJjyz4uxgp78NhDmmbxEk
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  7b329ba3cf144adc46ba7331eb454d3d
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-5eJjyz4uxgp78NhDmmbxEk
depends:
    Diff-0.5-KcBV17wTopECmrGDZnnXHj
    aeson-2.1.2.1-9cza8YJPY5Z8Ze3x8zf5ig
    aeson-pretty-0.8.10-7qMNvnYtok99X4YcmDfbkh
    ansi-terminal-1.0.2-HjENL9BIUVI6RnTwgiyfuy
    atomic-write-0.2.1.1-8VXpW2aFNoyXltqMUmglZ base-4.17.2.1
    base16-bytestring-1.0.2.0-2lCbsmyuV4cJM4iFUeYCbV
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-9yImpzTIYpBJ0v1fZqtWOj
    cborg-0.2.10.0-G8KqQa1iaYB7VVgxaBslM9
    cborg-json-0.2.6.0-IW9h7Zjyj0d59kYDMG9vAy containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-1udWDPLU3hl4niYrwEH29y
    data-fix-0.3.4-IAuVQTTnwSS16SuXmOC0dd deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-FOAbNcCNUjIJuj6gguErdR exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-8s3012fLvZ86fiVWYM6qyc
    hashable-1.4.4.0-EdBgVbn6YIuE9bA3dwmz04 haskeline-0.8.2
    http-client-0.7.19-2IAKaL0RajRLDWsZpaLmo9
    http-client-tls-0.3.6.4-1BDRKQL1P8oJwrUsm96xXK
    http-types-0.12.4-JKUCrzdlATTa7w8tKVNt1
    indexed-traversable-0.1.4-I4BD8iHmRbP9SiNqQBAmeX
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-G88a36osNzSFo1446urB6s
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-IX03DIUVxPAG8S8nkSZaDU
    optparse-applicative-0.18.1.0-6vzfjdGcscpK23HoS6KcvN
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-408Ysx6ZjoH8ZyaqBXF8rY
    pretty-simple-4.1.3.0-15TXXhibX3uvvKXujFK63
    prettyprinter-1.7.1-7LCr279S4u97FneESew6z
    prettyprinter-ansi-terminal-1.1.3-9QGQBbp5h95K5T1zzYNOLO
    profunctors-5.6.3-J6y4iD5C6dqAks6U9gKtk4
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-5VCcSe8kMhaKTje3aOa6OL
    serialise-0.2.6.1-BFu7bubgj3ZHwH8nBbSA9f template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-CWe1GLkbibZ4lKJkXwXzhL
    text-short-0.1.6-JKBEzsPWYHRLnQg5mcamup
    th-lift-instances-0.1.20-4HjTnSTWNPP2vA2BxjYpSt time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4.1-Gp2OJygcIQQ2h6Czdh8sny
    unordered-containers-0.2.20-8cMd7edANcDBeBDjVdjsZY
    vector-0.13.2.0-4gUGda2ISIbCv9ACnxMPCL

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

