#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-nJL8kjZmOX3g1CMbGwJ5G
key:                  dhall-1.42.2-nJL8kjZmOX3g1CMbGwJ5G
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  d72c2fa528fdabe9e3370edf20297baf
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-nJL8kjZmOX3g1CMbGwJ5G
depends:
    Diff-0.4.1-Jwj4OLAfw0yEVliC3dyBin
    aeson-2.1.2.1-8kv8xeVfmZaCzdZG9aqfKb
    aeson-pretty-0.8.10-7dtxg6jHAs4ItgdWHojTS1
    ansi-terminal-1.0.2-HptUcAgyCR58cokR0SMdxn
    atomic-write-0.2.1.1-EYI3D4QppEGwOCaljuWAO base-4.17.2.1
    base16-bytestring-1.0.2.0-JJa1KxJYGe36l1ilVfBYOe
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-KEDJwVxaVqqI97A4XPwej0
    cborg-0.2.10.0-I5R1RA3j33p2cFjTNKva5k
    cborg-json-0.2.6.0-3nFoOvyx1YK4abdyC04aPx containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-Et7cwM7DrDd7oCyfS7ieP8
    data-fix-0.3.4-JYg4OHIYKet86IYYftyaW2 deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-LIEalaJNK5HCYxNvsZbrPy exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-6a4Inb258qwLIHVNf59y7E
    hashable-1.4.4.0-BEEuzU8Xb1pET12cUzIyiR haskeline-0.8.2
    http-client-0.7.19-4PBxl7ykGvY1A1M3m4syiA
    http-client-tls-0.3.6.4-8XU3sE2WrKcAyR7Z9nyH2W
    http-types-0.12.4-5NSSMgOt7vT4e8131JaEsZ
    indexed-traversable-0.1.4-HG6KC0xY4QL1bu8moi9PYK
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.7.0-1voytdgo3wjFoCwR6CT9gz
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-4Or7NcWT1BFGL9jaSnxRbG
    optparse-applicative-0.18.1.0-6krVryETStC73hI3cDgd1Y
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-H2yQqyWcqomLvF8bEhKdlP
    pretty-simple-4.1.3.0-EkVb272bmdODICH6LBHauq
    prettyprinter-1.7.1-JBUxpob9pPVLD8OaO2d4B1
    prettyprinter-ansi-terminal-1.1.3-DPjP9lcwT5a9DsbOdvTpk3
    profunctors-5.6.3-9M4TtsMN5BR9uOEm2G73QR
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.8.0-4NIM1ptKK7Y3EgpQdVTV5l
    serialise-0.2.6.1-9f8VdEvIIi0IhMJEjsmLZI template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-BONAstaZoY8AaApsNwxOSa
    text-short-0.1.6-72L4XTpJm8f8n6a1xQ7zPw
    th-lift-instances-0.1.20-LqQiBhrNvof8IyTGKoQ4Ys time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-DNtjNiox36vAutr9B2n0Bm
    unordered-containers-0.2.20-IhcdMC6aki1KSQ4zttUKBR
    vector-0.13.2.0-B39FQf4cXUZ2GlwNF0TDTd

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

