#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-CEq1VwR4o8A9qw1L2CqSap
key:                  dhall-1.42.2-CEq1VwR4o8A9qw1L2CqSap
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  a71a78a89013f6617acd6c81a436fd6d
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-CEq1VwR4o8A9qw1L2CqSap
depends:
    Diff-0.4.1-HEnssu43s0k5bU1IlZ6xfs
    aeson-2.1.2.1-HPwo2VO3hzcFr4fiGB5Oro
    aeson-pretty-0.8.10-6mqlJbaGBfr9VazENxXqaY
    ansi-terminal-1.0.2-HPtVnAU9d4e2sgA8soPDqO
    atomic-write-0.2.1.1-741Zs3HDvTbBbyJclCQz8M base-4.17.2.1
    base16-bytestring-1.0.2.0-DtLhCS1yMgY3iFYZkoZd12
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-1ILAtZHAjAqgINNQwApUo
    cborg-0.2.10.0-xKFIjORy1kIrtj4XnzD9O
    cborg-json-0.2.6.0-BO9Bsuyj29KBbjldcL1GRV containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-JuksYLM6warBHNj9levj9A
    data-fix-0.3.4-B1IhiJz7xaJ1xVSkhKWXkK deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-7OqC9vdPUmx2v926gtr3Uy exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-FLj0m44bzXfGOAFKGkBNiG
    hashable-1.4.4.0-HCL6HYi7vZb6weAXUagHtJ haskeline-0.8.2
    http-client-0.7.18-IROMjfUUOqe2MZRLGJEp23
    http-client-tls-0.3.6.4-6ZcD1iDGS9Y6vJRxoNTqij
    http-types-0.12.4-B5DxmOwiWvxHN2hLvYjsdc
    indexed-traversable-0.1.4-GkGrJgji2sS1heT6R1yu0
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-EACNQE4V0s4sorPNkNSJS
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-2s4BpOjYszS9lLOXbJJXzp
    optparse-applicative-0.18.1.0-DiZJ1DIwWjI1ByXXnUKInq
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-7PEU0i9OZOhIj5xUnqMhs
    pretty-simple-4.1.3.0-A88uLLkM3q158fnBr3Zbhf
    prettyprinter-1.7.1-CblNKNR1eKT9nxUoBiyJi9
    prettyprinter-ansi-terminal-1.1.3-BetCIThzEOW7GW5IXaiUDk
    profunctors-5.6.3-9pKr3F9zUDFI44dXqzMZB2
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-58CM7xG7oFa5aLaqCWIm5T
    serialise-0.2.6.1-1JlVc1W0TYp1BmEUQgn1gc template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-LR8CjjSZPN54PZfsk1etxq
    text-short-0.1.6-7UHmRIV0Q9RCuRJBKZCz95
    th-lift-instances-0.1.20-EZfzjIJ9NWAFsisDHhtBMC time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-3zZqh7W5xPMF9DzEJo8QhX
    unordered-containers-0.2.20-FFF0GulGLFtAHq6N1Lkm0s
    vector-0.13.2.0-ZKpjTfyjPa7BNElf7Ue7Z

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

