#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-HV6FfMK3vUcDAWKxqLJ1ey
key:                  dhall-1.42.2-HV6FfMK3vUcDAWKxqLJ1ey
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  048622e908dbd073995da1dc5c936b0a
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-HV6FfMK3vUcDAWKxqLJ1ey
depends:
    Diff-0.4.1-4bau5Ft6A3lL0TAouRbHNm
    aeson-2.1.2.1-I3cDhpx2rWKJLPqMhNImsD
    aeson-pretty-0.8.10-3qPx22aOzVSBFvPKpFFIPj
    ansi-terminal-1.0.2-7NrSlZkI0QJFeJ1Fjfyc7F
    atomic-write-0.2.1.1-2wCwql24hPCCtzDcg70LCW base-4.17.2.1
    base16-bytestring-1.0.2.0-ECUgG9vdSqNJnBC8i5DqcO
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-4L9O7i2dYOAKEL3KQ9PGzi
    cborg-0.2.10.0-BraJewsuGBbFpcx13gbABW
    cborg-json-0.2.6.0-5Kbq3iMrdIh1YtODgehN5L containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-ARff3pI8POvH9w75oiB0iN
    data-fix-0.3.4-HEhzBWaytGr13QVzO1czd2 deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-CSOElsKPywoL9LBIzXKHba exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-325jAuCd0CAHSNZlOQKGhp
    hashable-1.4.4.0-44s1yyL7bsg7gxbZe8O55H haskeline-0.8.2
    http-client-0.7.18-32Vk6tT4ZtsDSDwD6SZUNX
    http-client-tls-0.3.6.4-1JiSbwRbiQBUXev8qZpb0
    http-types-0.12.4-Jqk2Jx5UWUVCRsxSGHbgCJ
    indexed-traversable-0.1.4-8dufgEA3LInFduylpBTbnE
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-3yibAuuj99cCAoA6eavpya
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-2wn7iZJrXjeInsr3q1MEy6
    optparse-applicative-0.18.1.0-45ilwwujMWa48E4roXiDVU
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-H7Ug8KpOx7q4DFUXxpRK1j
    pretty-simple-4.1.3.0-DQUFyEkKFpBBFwkdLZQCZa
    prettyprinter-1.7.1-CHull9pmVmmH6lhklehupY
    prettyprinter-ansi-terminal-1.1.3-FvMCqux6WjUGKCQA0x6KPI
    profunctors-5.6.3-Ax92vk6p9JS8k5RnuBgyEb
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-LRwgjpG5BvCx0EKDOkZKX
    serialise-0.2.6.1-27zEaW5tfPD1R1rmuC91Dm template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-6s6Q4qXSF4sC2medFEI5WD
    text-short-0.1.6-N3ycByF7TxJ7Zkjvy0gDU
    th-lift-instances-0.1.20-8mpvrdyHFu3A6Zd9ebPFds time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-KfBE08UEeeCA58QEAAwfFt
    unordered-containers-0.2.20-2ikAr0D5DLKB57N2l8lLdR
    vector-0.13.2.0-Hj69nwJTcAJ4Jep1PSRV8B

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

