#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-9DA39iUclbq9d0vhai4ABH
key:                  dhall-1.42.2-9DA39iUclbq9d0vhai4ABH
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  aeaae4410406231a6ff80ce5c430c814
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-9DA39iUclbq9d0vhai4ABH
depends:
    Diff-0.4.1-HJV1rtBqYEF2jsWLwGkam0
    aeson-2.1.2.1-4jhjW2ARw2KEAv1jKZWvea
    aeson-pretty-0.8.10-7u9BNMuGpheBPXf26gKGQX
    ansi-terminal-1.0.2-6ZbytJewXtEJSCVeiG0zJh
    atomic-write-0.2.1.1-BLeg4tThUJqnnJL181uxS base-4.17.2.1
    base16-bytestring-1.0.2.0-5CqdDAFWvdCp6PyRr0Kc1 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-AQlcRYTbpYHDf3yXCQ8vD
    cborg-0.2.10.0-LLvbJISVtjJJuzyqYFv0bN
    cborg-json-0.2.6.0-ChL83JFXVYC6XwElJ7oXct containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-eTkxZOYnL81OlemPaXwsH
    data-fix-0.3.4-H6oAgPfdjaj6sRxME2eTKY deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-4owGGDEC3Ho5uV1VlTByjF exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-BWQo9ne9qeOFHKVFeEsaaP
    hashable-1.4.4.0-9qNl3SeJnhrLashClEgMWi haskeline-0.8.2
    http-client-0.7.18-DFBosHkVLwfXJx5FRw6cm
    http-client-tls-0.3.6.4-5jWVmhTkn93DOKTANR4nfi
    http-types-0.12.4-G2ezwfHC5h73tYQ7CehVoi
    indexed-traversable-0.1.4-CTahURRXjw49vb9T0Fbkhh
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-3H8EOUetCGeLsPiQfmnZHv
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-2IU2t8Ax31o1usrGuCfdSi
    optparse-applicative-0.18.1.0-Ix8zjHzI9uzAcoBRTHipAX
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-Cut39vrf0Cb7kjKAqVdNK5
    pretty-simple-4.1.3.0-2hbe4ywUqxtLSi4mJSMyQK
    prettyprinter-1.7.1-1pn6gzZ0MkiHs9ThnkXsu7
    prettyprinter-ansi-terminal-1.1.3-EiGFi7p5pD34VGmBtQg4Hx
    profunctors-5.6.3-763QtBuoI7Z6aooPgg5WPo
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-4FcyuuYLyZfH2Qw2NEk9yg
    serialise-0.2.6.1-56QDYIKBQVYJQKzkzJvmXY template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-4a5xABo2Kh9LPutUitVgOH
    text-short-0.1.6-7Vjzl8Kg3WgGTSwhYCxeYE
    th-lift-instances-0.1.20-6iAGSMReBpJGId9OAbKCqK time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-1OXKcxKduTfAtZcBY2NYwq
    unordered-containers-0.2.20-DP4QHaCUkq0wtUis18g4W
    vector-0.13.2.0-GsBUDodNeES1JkqRBIgHko

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

