#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-HJTHPLvJ9Ka3EW61GggDbz
key:                  dhall-1.42.2-HJTHPLvJ9Ka3EW61GggDbz
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  40423a3a6418bbe0a28b433f96bcd32a
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-HJTHPLvJ9Ka3EW61GggDbz
depends:
    Diff-0.4.1-8NUfR4WKqY5H9Ttf0Koorw
    aeson-2.1.2.1-5BFfk7iI7w6HPWzhbIRzqn
    aeson-pretty-0.8.10-CwXo2PdeXuRCVi5BLDBjO7
    ansi-terminal-1.0.2-J3CYMek3QCg8mQRiAxriIL
    atomic-write-0.2.1.1-HBo4VhTzkXk5VSIlsCdGJm base-4.17.2.1
    base16-bytestring-1.0.2.0-FPGhlHO3pZ4wh96uZmnW2 bytestring-0.11.5.3
    case-insensitive-1.2.1.0-CCVT39CBetAFHWteAF796d
    cborg-0.2.10.0-9YwiJPtJE6VCBzy2VJkNF2
    cborg-json-0.2.6.0-Fn5Hubuz7XSAI6EYuSSbNo containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-ov9HB00BerKcLhEmGqOet
    data-fix-0.3.4-9PkjGUZ39YgHGK8J4WwgYb deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-2PCrQ7SacCXAqIxUV5Gwaq exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-5jHXvn7XCJUDkDlK0pAxHn
    hashable-1.4.4.0-HayYj9uqgN4KUEsvzi6aVt haskeline-0.8.2
    http-client-0.7.18-EyzJQbPJ45W9RPu7xSmNVF
    http-client-tls-0.3.6.4-EPZBeFlxUNP9RvBjuZP5AP
    http-types-0.12.4-9uVTqdZnsIVFg4lqnMzjN5
    indexed-traversable-0.1.4-92FdEpJkEfDIV3402POC6M
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-LBbcO7GVsOtJwvx1ioFUK2
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-69U48sX3jSI9NKFFT4iJZQ
    optparse-applicative-0.18.1.0-LAqtHJr780D5qPLgkEOKur
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-56g1Nx5LuKy21C9ziCb1ow
    pretty-simple-4.1.3.0-HF9R9qQrZA3K7viRHqI1Dx
    prettyprinter-1.7.1-7RzBp6WzYsKH449UzuuntO
    prettyprinter-ansi-terminal-1.1.3-LoL3RNOrI4LLVb0h5b4flD
    profunctors-5.6.3-3RJN4RwyYywEf8j0QOKtB
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-KrMKCvnfUrQHIZNLkrXCwo
    serialise-0.2.6.1-HsgEFKQNYeg7ri2jJCZl2X template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-3yLCJ7g7PpzIlbjKC7lKXp
    text-short-0.1.6-HxspKI7S9yP79VSR7RqBXq
    th-lift-instances-0.1.20-ARYUlM6REJ8CBRqmcBGlYv time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-9MupkolZ0caFxVneXpCKPL
    unordered-containers-0.2.20-2eRdi4Eno3wAApPXuoC33k
    vector-0.13.2.0-KVjnIHG2Fg91rA02TsgQOf

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

