#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.2
visibility:           public
id:                   dhall-1.42.2-LORaIJh1k346gKMmcYNc62
key:                  dhall-1.42.2-LORaIJh1k346gKMmcYNc62
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  7ac887ab333f3ebc720210b658c843fb
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.2-LORaIJh1k346gKMmcYNc62
depends:
    Diff-0.4.1-L8DOUuNGxiiH0X79lq9Zn6
    aeson-2.1.2.1-Gng3eoGBP2Sj2fbUBsnWH
    aeson-pretty-0.8.10-1UVA7jwF3AY2XeDKFp8bmR
    ansi-terminal-1.0.2-KEBwSt8cOBhArBBqY461TL
    atomic-write-0.2.1.1-7EqwZmYUiQIBbFLoUlctrh base-4.17.2.1
    base16-bytestring-1.0.2.0-8y3SyptL8obHk6RuDrxcpW
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-IiC4W3ne2FhKO4v0Ko50kd
    cborg-0.2.10.0-LP8zqmMUHbt3uW0XeRfpla
    cborg-json-0.2.6.0-GLlwG30LGbkiqJGFy8Y2i containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-B0dHxYRWPrO346e6jKDe9T
    data-fix-0.3.4-EWneHNF8HkN6urvLVK6uGt deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.3-HSeWVXxcHDG8FkBCehblq1 exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.3-BaY2riEqZq66qHqzTTjrJz
    hashable-1.4.4.0-D3M5e9EeJxCJTqzfO7ugwa haskeline-0.8.2
    http-client-0.7.18-459exqS5txS1OoId3JMPZk
    http-client-tls-0.3.6.4-7S2cUrl1lPP9SbVvzQv2U1
    http-types-0.12.4-GvCYNDYAmXh2LOy70F8sjw
    indexed-traversable-0.1.4-DOGxrFcaLiiKO9QlCmrhlX
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-EGAiipKGhRa2zjyQ3XtPp3
    mmorph-1.2.1-Dj3j5073UbJL5k7iF3E3ML mtl-2.2.2
    network-uri-2.6.4.2-3JlqJJTWpo6F8MNpnCbeng
    optparse-applicative-0.18.1.0-26u6tT1hMVXIAnAEQGbXYx
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-6PROTB9MCEOF2XC4sNQYpQ
    pretty-simple-4.1.3.0-CkqLo4aUnyFEQrybXEhNp8
    prettyprinter-1.7.1-G37JwSOM6BFGPcFlHNjXb6
    prettyprinter-ansi-terminal-1.1.3-BtkpNj27yDz2ET1Er4fc8d
    profunctors-5.6.3-Bt9MVhlRTOZ9jp4jf1b56Q
    repline-0.4.3.0-IA6pkTlLfO41EsusxrvZPb
    scientific-0.3.7.0-43723I2k3fJ8FjtljY7WIm
    serialise-0.2.6.1-DFoD4amxcEpBg8rA1heLMN template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-JTYe2zq2OSd2qDKpMKbASW
    text-short-0.1.6-9QS7P25wx0CFF1GLqhXjK
    th-lift-instances-0.1.20-7pb5VwZMWHn8eGCFOTiBRt time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-78l8MOdFsjkFPxntqtUi8y
    unordered-containers-0.2.20-Asw2mvs6LgrELNyeUEam3W
    vector-0.13.2.0-G0g5gCprguQ6M58H7uQE53

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

