/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.statement.select;

import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.ParenthesedStatement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.FromItemVisitor;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.Pivot;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.SampleClause;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectVisitor;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.TableFunction;
import net.sf.jsqlparser.statement.select.UnPivot;
import net.sf.jsqlparser.statement.select.Values;

public class ParenthesedSelect
extends Select
implements FromItem,
ParenthesedStatement {
    Alias alias;
    Pivot pivot;
    UnPivot unPivot;
    Select select;
    SampleClause sampleClause = null;

    public ParenthesedSelect() {
    }

    public ParenthesedSelect(FromItem fromItem) {
        this.select = new PlainSelect(fromItem);
        this.alias = ParenthesedSelect.getAliasFromItem(fromItem);
    }

    public ParenthesedSelect(FromItem fromItem, Expression whereExpressions) {
        this.select = new PlainSelect(fromItem, whereExpressions);
        this.alias = ParenthesedSelect.getAliasFromItem(fromItem);
    }

    public ParenthesedSelect(FromItem fromItem, Collection<Expression> orderByExpressions) {
        this.select = new PlainSelect(fromItem, orderByExpressions);
        this.alias = ParenthesedSelect.getAliasFromItem(fromItem);
    }

    public ParenthesedSelect(FromItem fromItem, Expression whereExpressions, Collection<Expression> orderByExpressions) {
        this.select = new PlainSelect(fromItem, whereExpressions, orderByExpressions);
        this.alias = ParenthesedSelect.getAliasFromItem(fromItem);
    }

    public ParenthesedSelect(Collection<Expression> selectExpressions, FromItem fromItem) {
        this.select = new PlainSelect(selectExpressions, fromItem);
        this.alias = ParenthesedSelect.getAliasFromItem(fromItem);
    }

    public ParenthesedSelect(Collection<Expression> selectExpressions, FromItem fromItem, Expression whereExpressions) {
        this.select = new PlainSelect(selectExpressions, fromItem, whereExpressions);
        this.alias = ParenthesedSelect.getAliasFromItem(fromItem);
    }

    public ParenthesedSelect(Collection<Expression> selectExpressions, FromItem fromItem, Collection<Expression> orderByExpressions) {
        this.select = new PlainSelect(selectExpressions, fromItem, orderByExpressions);
        this.alias = ParenthesedSelect.getAliasFromItem(fromItem);
    }

    public ParenthesedSelect(Collection<Expression> selectExpressions, FromItem fromItem, Expression whereExpressions, Collection<Expression> orderByExpressions) {
        this.select = new PlainSelect(selectExpressions, fromItem, whereExpressions, orderByExpressions);
        this.alias = ParenthesedSelect.getAliasFromItem(fromItem);
    }

    private static Alias getAliasFromItem(FromItem fromItem) {
        if (fromItem instanceof Table && fromItem.getAlias() == null) {
            Table t = (Table)fromItem;
            return new Alias(t.getName(), true);
        }
        if (fromItem instanceof TableFunction && fromItem.getAlias() == null) {
            TableFunction t = (TableFunction)fromItem;
            return new Alias(t.getName(), true);
        }
        return fromItem.getAlias() != null ? new Alias(fromItem.getAlias().getName(), true) : null;
    }

    @Override
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(Alias alias) {
        this.alias = alias;
    }

    @Override
    public ParenthesedSelect withAlias(Alias alias) {
        this.setAlias(alias);
        return this;
    }

    @Override
    public Pivot getPivot() {
        return this.pivot;
    }

    @Override
    public void setPivot(Pivot pivot) {
        this.pivot = pivot;
    }

    @Override
    public UnPivot getUnPivot() {
        return this.unPivot;
    }

    @Override
    public void setUnPivot(UnPivot unPivot) {
        this.unPivot = unPivot;
    }

    @Override
    public SampleClause getSampleClause() {
        return this.sampleClause;
    }

    @Override
    public FromItem setSampleClause(SampleClause sampleClause) {
        this.sampleClause = sampleClause;
        return this;
    }

    public ParenthesedSelect withSampleClause(SampleClause sampleClause) {
        this.sampleClause = sampleClause;
        return this;
    }

    public Select getSelect() {
        return this.select;
    }

    public void setSelect(Select select) {
        this.select = select;
    }

    @Override
    public Values getValues() {
        return (Values)this.select;
    }

    @Override
    public PlainSelect getPlainSelect() {
        return (PlainSelect)this.select;
    }

    @Override
    public SetOperationList getSetOperationList() {
        return (SetOperationList)this.select;
    }

    public ParenthesedSelect withSelect(Select selectBody) {
        this.setSelect(selectBody);
        return this;
    }

    @Override
    public ParenthesedSelect withOrderByElements(List<OrderByElement> orderByElements) {
        this.select.setOrderByElements(orderByElements);
        return this;
    }

    @Override
    public <T, S> T accept(SelectVisitor<T> selectVisitor, S context) {
        return selectVisitor.visit(this, context);
    }

    @Override
    public <T, S> T accept(FromItemVisitor<T> fromItemVisitor, S context) {
        return fromItemVisitor.visit(this, context);
    }

    @Override
    public <T, S> T accept(StatementVisitor<T> statementVisitor, S context) {
        return statementVisitor.visit(this, context);
    }

    @Override
    public StringBuilder appendSelectBodyTo(StringBuilder builder) {
        builder.append("(").append(this.select).append(")");
        this.appendTo(builder, this.alias, this.sampleClause, this.pivot, this.unPivot);
        return builder;
    }
}

