/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.tools.transfer.stream.StreamDataImporterColumnInfo;
import org.jkiss.dbeaver.tools.transfer.stream.model.StreamDataSource;
import org.jkiss.utils.CommonUtils;

public class StreamEntityMapping
implements DBSEntity,
DBSDataContainer,
DBPQualifiedObject {
    @NotNull
    private final Path inputFile;
    @NotNull
    private final DBPDataSource dataSource;
    @NotNull
    private final String entityName;
    private final List<StreamDataImporterColumnInfo> streamColumns = new ArrayList<StreamDataImporterColumnInfo>();
    private final boolean child;

    public StreamEntityMapping(@NotNull Path inputFile) {
        this(inputFile, StreamEntityMapping.getEntityNameFromFile(inputFile), false);
    }

    @NotNull
    private static String getEntityNameFromFile(@NotNull Path inputFile) {
        Path fileName = inputFile.getFileName();
        if (fileName != null) {
            return fileName.toString();
        }
        return inputFile.toUri().toString();
    }

    public StreamEntityMapping(@NotNull Path inputFile, @NotNull String entityName, boolean child) {
        this.inputFile = inputFile;
        this.entityName = entityName;
        this.dataSource = new StreamDataSource(entityName);
        this.child = child;
    }

    StreamEntityMapping(@NotNull DBRProgressMonitor monitor, @Nullable DBPProject project, @NotNull Map<String, Object> config) throws DBException {
        this.entityName = CommonUtils.toString((Object)config.get("entityId"));
        String inputFileName = CommonUtils.toString((Object)config.get("inputFile"));
        if (CommonUtils.isEmpty((String)inputFileName)) {
            inputFileName = this.entityName;
        }
        this.inputFile = DBFUtils.resolvePathFromString((DBRProgressMonitor)monitor, (DBPProject)project, (String)inputFileName);
        this.dataSource = new StreamDataSource(this.entityName);
        this.child = false;
    }

    @NotNull
    public Path getInputFile() {
        return this.inputFile;
    }

    @NotNull
    public String getEntityName() {
        return this.entityName;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    public List<StreamDataImporterColumnInfo> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.streamColumns;
    }

    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (DBSEntityAttribute)DBUtils.findObject(this.streamColumns, (String)attributeName);
    }

    public Collection<? extends DBSEntityConstraint> getConstraints(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getAssociations(@NotNull DBRProgressMonitor monitor) {
        return null;
    }

    public Collection<? extends DBSEntityAssociation> getReferences(@NotNull DBRProgressMonitor monitor) {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public DBSObject getParentObject() {
        return this.dataSource;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public String[] getSupportedFeatures() {
        return new String[]{"data.select"};
    }

    @NotNull
    public DBCStatistics readData(@Nullable DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        throw new DBCException("Not implemented");
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) {
        return -1L;
    }

    @NotNull
    public String getName() {
        return this.entityName;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return this.getName();
    }

    public List<StreamDataImporterColumnInfo> getStreamColumns() {
        return this.streamColumns;
    }

    public boolean isChild() {
        return this.child;
    }

    void setStreamColumns(List<StreamDataImporterColumnInfo> streamColumns) {
        this.streamColumns.clear();
        for (StreamDataImporterColumnInfo column : streamColumns) {
            this.ensureNameIsUnique(column);
            this.streamColumns.add(column);
        }
    }

    public StreamDataImporterColumnInfo getStreamColumn(String name) {
        for (StreamDataImporterColumnInfo col : this.streamColumns) {
            if (!name.equals(col.getName())) continue;
            return col;
        }
        return null;
    }

    Map<String, Object> saveSettings() {
        LinkedHashMap<String, Object> mappings = new LinkedHashMap<String, Object>();
        mappings.put("entityId", this.entityName);
        return mappings;
    }

    public boolean isSameColumns(@NotNull StreamEntityMapping mapping) {
        if (this.streamColumns.size() != mapping.streamColumns.size()) {
            return false;
        }
        int index = 0;
        while (index < this.streamColumns.size()) {
            StreamDataImporterColumnInfo oldColumn = this.streamColumns.get(index);
            StreamDataImporterColumnInfo newColumn = mapping.streamColumns.get(index);
            if (!oldColumn.getName().equals(newColumn.getName())) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamEntityMapping that = (StreamEntityMapping)o;
        return this.inputFile.equals(that.inputFile) && this.entityName.equals(that.entityName);
    }

    public int hashCode() {
        return Objects.hash(this.inputFile, this.entityName);
    }

    private void ensureNameIsUnique(@NotNull StreamDataImporterColumnInfo column) {
        int i = 0;
        while (i < this.streamColumns.size() + 1) {
            String name = i > 0 ? column.getName() + "_" + i : column.getName();
            boolean collides = false;
            for (StreamDataImporterColumnInfo other : this.streamColumns) {
                if (!other.getName().equalsIgnoreCase(name)) continue;
                collides = true;
                break;
            }
            if (!collides) {
                column.setName(name);
                return;
            }
            ++i;
        }
    }
}

