/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPDataSourceOriginExternal;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDataSourceProviderDescriptor;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverSubstitutionDescriptor;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.net.DBWHandlerDescriptor;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.DataSourceViewDescriptor;
import org.jkiss.dbeaver.registry.DataSourceViewRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerDescriptor;
import org.jkiss.dbeaver.registry.network.NetworkHandlerRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.ICompositeDialogPageContainer;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditor;
import org.jkiss.dbeaver.ui.IDataSourceConnectionEditorSite;
import org.jkiss.dbeaver.ui.IDataSourceConnectionTester;
import org.jkiss.dbeaver.ui.IDialogPageProvider;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ActiveWizardPage;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.dialogs.MessageBoxBuilder;
import org.jkiss.dbeaver.ui.dialogs.Reply;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageNetworkHandler;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizard;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionWizardPage;
import org.jkiss.dbeaver.ui.dialogs.driver.DriverEditDialog;
import org.jkiss.dbeaver.ui.preferences.PrefPageProjectNetworkProfiles;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

class ConnectionPageSettings
extends ActiveWizardPage<ConnectionWizard>
implements IDataSourceConnectionEditorSite,
IDialogPageProvider,
ICompositeDialogPageContainer,
IDataSourceConnectionTester {
    public static final String PAGE_NAME = ConnectionPageSettings.class.getSimpleName();
    private static final Log log = Log.getLog(DriverDescriptor.class);
    private static final Reply REPLY_KEEP = new Reply("&Keep");
    private static final Reply REPLY_REMOVE = new Reply("&Remove");
    private static final Comparator<IDialogPage> PAGE_COMPARATOR = Comparator.comparing(ConnectionPageSettings::isHandlerPage);
    private static final int MAX_CHEVRON_ITEMS_TO_PREVIEW = 2;
    @NotNull
    private final ConnectionWizard wizard;
    @NotNull
    private final DataSourceViewDescriptor viewDescriptor;
    private final DataSourceViewDescriptor substitutedViewDescriptor;
    private final DBPDriverSubstitutionDescriptor driverSubstitution;
    @Nullable
    private IDataSourceConnectionEditor connectionEditor;
    private IDataSourceConnectionEditor originalConnectionEditor;
    private final Set<DataSourceDescriptor> activated = new HashSet<DataSourceDescriptor>();
    private IDialogPage[] subPages;
    private IDialogPage[] extraPages;
    private CTabFolder tabFolder;
    private ToolItem handlerItem;
    private ToolItem profileItem;

    ConnectionPageSettings(@NotNull ConnectionWizard wizard, @NotNull DataSourceViewDescriptor viewDescriptor, @Nullable DBPDriverSubstitutionDescriptor driverSubstitution) {
        super(PAGE_NAME + "." + viewDescriptor.getId());
        Object pageTitle;
        this.wizard = wizard;
        this.viewDescriptor = viewDescriptor;
        this.driverSubstitution = driverSubstitution;
        this.substitutedViewDescriptor = driverSubstitution != null ? DataSourceViewRegistry.getInstance().findView((DBPDataSourceProviderDescriptor)DataSourceProviderRegistry.getInstance().getDataSourceProvider(driverSubstitution.getProviderId()), "org.jkiss.dbeaver.ext.ui.editConnectionDialog") : null;
        Object object = pageTitle = wizard.isNew() ? viewDescriptor.getLabel() : CoreMessages.dialog_setting_connection_wizard_title;
        if (this.isTemporaryConnection()) {
            pageTitle = (String)pageTitle + " / TEMPORARY";
        }
        this.setTitle((String)pageTitle);
        this.setDescription(CoreMessages.dialog_connection_description);
    }

    @NotNull
    private IDataSourceConnectionEditor getConnectionEditor() {
        if (this.connectionEditor == null) {
            if (this.substitutedViewDescriptor == null) {
                this.connectionEditor = this.getOriginalConnectionEditor();
            } else {
                this.connectionEditor = (IDataSourceConnectionEditor)this.substitutedViewDescriptor.createView(IDataSourceConnectionEditor.class);
                this.connectionEditor.setSite((IDataSourceConnectionEditorSite)this);
            }
        }
        return this.connectionEditor;
    }

    @NotNull
    private IDataSourceConnectionEditor getOriginalConnectionEditor() {
        if (this.originalConnectionEditor == null) {
            this.originalConnectionEditor = (IDataSourceConnectionEditor)this.viewDescriptor.createView(IDataSourceConnectionEditor.class);
            this.originalConnectionEditor.setSite((IDataSourceConnectionEditorSite)this);
        }
        return this.originalConnectionEditor;
    }

    public void activatePage() {
        if (this.connectionEditor == null) {
            this.createProviderPage(this.getControl().getParent());
        }
        Control control = this.getControl();
        control.setRedraw(false);
        try {
            this.setDescription(NLS.bind((String)CoreMessages.dialog_connection_message, (Object)this.getDriver().getFullName()));
            DataSourceDescriptor connectionInfo = this.getActiveDataSource();
            if (!this.activated.contains(connectionInfo)) {
                if (this.connectionEditor != null) {
                    this.connectionEditor.loadSettings();
                }
                if (this.subPages != null) {
                    IDialogPage[] iDialogPageArray = this.subPages;
                    int n = this.subPages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDialogPage page = iDialogPageArray[n2];
                        Control pageControl = page.getControl();
                        if (pageControl != null && page instanceof IDataSourceConnectionEditor) {
                            ((IDataSourceConnectionEditor)page).loadSettings();
                        }
                        ++n2;
                    }
                }
                this.activated.add(connectionInfo);
            } else if (this.connectionEditor != null) {
                this.connectionEditor.loadSettings();
            }
            this.activateCurrentItem();
        }
        finally {
            control.setRedraw(true);
        }
        UIUtils.asyncExec(() -> this.connectionEditor.activateEditor());
    }

    public void deactivatePage() {
        DataSourceDescriptor connectionInfo = this.getActiveDataSource();
        if (this.activated.contains(connectionInfo) && this.connectionEditor != null) {
            this.connectionEditor.saveSettings((DBPDataSourceContainer)connectionInfo);
        }
        super.deactivatePage();
    }

    public Image getImage() {
        Image image;
        if (this.connectionEditor != null && (image = this.connectionEditor.getImage()) != null) {
            return image;
        }
        return super.getImage();
    }

    void saveSettings(DataSourceDescriptor dataSource) {
        if (this.subPages != null) {
            IDialogPage[] iDialogPageArray = this.subPages;
            int n = this.subPages.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogPage page = iDialogPageArray[n2];
                if (!ArrayUtils.contains((Object[])this.extraPages, (Object)page)) {
                    if (page.getControl() != null && page instanceof IDataSourceConnectionEditor) {
                        ((IDataSourceConnectionEditor)page).saveSettings((DBPDataSourceContainer)dataSource);
                    } else if (page instanceof ConnectionWizardPage) {
                        ((ConnectionWizardPage)page).saveSettings((DBPDataSourceContainer)dataSource);
                    }
                }
                ++n2;
            }
        }
        if (this.connectionEditor != null) {
            this.connectionEditor.saveSettings((DBPDataSourceContainer)dataSource);
        }
    }

    public void createControl(Composite parent) {
        if (this.wizard.isNew()) {
            this.setControl((Control)new Composite(parent, 2048));
        } else {
            this.createProviderPage(parent);
        }
    }

    private void createProviderPage(Composite parent) {
        if (this.connectionEditor != null && this.connectionEditor.getControl() != null) {
            return;
        }
        if (this.getControl() != null) {
            this.getControl().dispose();
        }
        try {
            this.getConnectionEditor();
            Object[] allSubPages = this.getDialogPages(false, true);
            final ArrayList<IDialogPage> allPages = new ArrayList<IDialogPage>();
            allPages.add((IDialogPage)this.connectionEditor);
            if (!ArrayUtils.isEmpty((Object[])allSubPages)) {
                Collections.addAll(allPages, allSubPages);
            }
            allPages.sort(PAGE_COMPARATOR);
            this.tabFolder = new CTabFolder(parent, 128);
            this.tabFolder.setLayoutData((Object)new GridData(1808));
            this.tabFolder.setUnselectedCloseVisible(false);
            Composite toolBarComposite = new Composite((Composite)this.tabFolder, 0);
            toolBarComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).create());
            ToolBar toolBar = new ToolBar(toolBarComposite, 0x820000);
            this.handlerItem = this.createHandlerItem(toolBar, allPages);
            this.profileItem = this.createProfileItem(toolBar);
            this.tabFolder.setTopRight((Control)toolBarComposite, 131072);
            UIStyles.fixToolBarForeground((ToolBar)toolBar);
            this.updateHandlerItem(allPages);
            this.updateProfileItem();
            this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                public void close(CTabFolderEvent event) {
                    CTabItem item = (CTabItem)event.item;
                    if (!ConnectionPageSettings.this.closeTab(item)) {
                        event.doit = false;
                    }
                }

                public void itemsCount(CTabFolderEvent event) {
                    ConnectionPageSettings.this.updateHandlerItem(allPages);
                }
            });
            this.tabFolder.addMouseListener(MouseListener.mouseUpAdapter(event -> {
                CTabFolder folder;
                CTabItem item;
                if (event.button == 2 && (item = (folder = (CTabFolder)event.widget).getItem(new Point(event.x, event.y))) != null) {
                    this.closeTab(item);
                }
            }));
            this.tabFolder.addKeyListener(KeyListener.keyPressedAdapter(event -> {
                CTabFolder folder;
                CTabItem selection;
                if (event.keyCode == 127 && event.stateMask == 0 && (selection = (folder = (CTabFolder)event.widget).getSelection()) != null) {
                    this.closeTab(selection);
                }
            }));
            this.setControl((Control)this.tabFolder);
            for (IDialogPage page : allPages) {
                if (ArrayUtils.contains((Object[])this.extraPages, (Object)page) || this.canAddHandler(page)) continue;
                this.createPageTab(page, this.tabFolder.getItemCount());
            }
            this.tabFolder.setSelection(0);
            this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConnectionPageSettings.this.activateCurrentItem();
                }
            });
            this.activateCurrentItem();
            Dialog.applyDialogFont((Control)this.tabFolder);
            UIUtils.setHelp((Control)this.getControl(), (String)"con-wizard-settings");
        }
        catch (Exception ex) {
            log.warn((Object)ex);
            this.setErrorMessage("Can't create settings dialog: " + ex.getMessage());
        }
        parent.layout();
    }

    @NotNull
    private ToolItem createHandlerItem(@NotNull ToolBar toolBar, @NotNull List<IDialogPage> pages) {
        MenuManager handlerManager = new MenuManager();
        handlerManager.setRemoveAllWhenShown(true);
        handlerManager.addMenuListener(manager -> {
            for (IDialogPage page : pages) {
                if (!this.canAddHandler(page) || !(page instanceof ConnectionPageNetworkHandler)) continue;
                ConnectionPageNetworkHandler handlerPage = (ConnectionPageNetworkHandler)page;
                manager.add((IAction)new AddHandlerAction((DBWHandlerDescriptor)handlerPage.getHandlerDescriptor()));
            }
        });
        ToolItem toolItem = new ToolItem(toolBar, 4);
        toolItem.setText(CoreMessages.dialog_connection_network_add_tunnel_label);
        toolItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ADD));
        toolItem.addDisposeListener(e -> handlerManager.dispose());
        toolItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Rectangle bounds = toolItem.getBounds();
            Point location = toolBar.getDisplay().map((Control)toolBar, null, bounds.x, bounds.height);
            Menu menu = handlerManager.createContextMenu((Control)this.tabFolder);
            menu.setLocation(location.x, location.y);
            menu.setVisible(true);
        }));
        return toolItem;
    }

    @NotNull
    private ToolItem createProfileItem(@NotNull ToolBar toolBar) {
        MenuManager profileManager = new MenuManager();
        profileManager.setRemoveAllWhenShown(true);
        profileManager.addMenuListener(manager -> {
            manager.add((IAction)new ChooseNetworkProfileAction());
            manager.add((IContributionItem)new Separator());
            DataSourceDescriptor dataSource = this.getActiveDataSource();
            int index = 0;
            DBPDataSourceOrigin dBPDataSourceOrigin = dataSource.getOrigin();
            if (dBPDataSourceOrigin instanceof DBPDataSourceOriginExternal) {
                DBPDataSourceOriginExternal origin = (DBPDataSourceOriginExternal)dBPDataSourceOrigin;
                for (DBWNetworkProfile profile : origin.getAvailableNetworkProfiles()) {
                    manager.add((IAction)new ChooseNetworkProfileAction((DBPDataSourceContainer)dataSource, profile, (DBPDataSourceOrigin)origin, index++));
                }
            }
            manager.add((IContributionItem)new Separator());
            for (DBWNetworkProfile profile : this.getProject().getDataSourceRegistry().getNetworkProfiles()) {
                manager.add((IAction)new ChooseNetworkProfileAction((DBPDataSourceContainer)dataSource, profile, null, index++));
            }
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action("Edit profiles...", DBeaverIcons.getImageDescriptor((DBPImage)UIIcon.RENAME)){

                public void run() {
                    DBWNetworkProfile profile = ConnectionPageSettings.this.getActiveProfile();
                    PrefPageProjectNetworkProfiles.open((Shell)ConnectionPageSettings.this.getShell(), (RCPProject)ConnectionPageSettings.this.getProject(), (DBWNetworkProfile)profile);
                    if (profile != null) {
                        ConnectionPageSettings.this.selectProfile(profile);
                    }
                }
            });
        });
        ToolItem toolItem = new ToolItem(toolBar, 4);
        toolItem.setText("N/A");
        toolItem.setToolTipText("Active profile");
        toolItem.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TYPE_DOCUMENT));
        toolItem.addDisposeListener(e -> profileManager.dispose());
        toolItem.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            Rectangle bounds = toolItem.getBounds();
            Point location = toolBar.getDisplay().map((Control)toolBar, null, bounds.x, bounds.height);
            Menu menu = profileManager.createContextMenu((Control)this.tabFolder);
            menu.setLocation(location.x, location.y);
            menu.setVisible(true);
        }));
        return toolItem;
    }

    @NotNull
    private String computeChevronTitle(@NotNull List<IDialogPage> pages) {
        List<String> items = pages.stream().filter(this::canAddHandler).map(ConnectionPageNetworkHandler.class::cast).map(x -> x.getHandlerDescriptor().getCodeName()).toList();
        StringJoiner joiner = new StringJoiner(", ");
        int i = 0;
        while (i < Math.min(items.size(), 2)) {
            joiner.add(items.get(i));
            ++i;
        }
        if (items.size() > 2) {
            joiner.add("...");
        }
        return joiner.toString();
    }

    private void updateHandlerItem(@NotNull List<IDialogPage> allPages) {
        if (this.hasHandlersToAdd(allPages)) {
            this.handlerItem.setText(this.computeChevronTitle(allPages));
            this.handlerItem.setImage(DBeaverIcons.getImage((DBPImage)UIIcon.ADD));
            this.handlerItem.setEnabled(true);
        } else {
            this.handlerItem.setText("");
            this.handlerItem.setImage(null);
            this.handlerItem.setEnabled(false);
        }
    }

    private void updateProfileItem() {
        String profileName = this.getActiveDataSource().getConnectionConfiguration().getConfigProfileName();
        if (CommonUtils.isNotEmpty((String)profileName)) {
            this.profileItem.setText(NLS.bind((String)"Profile ''{0}''", (Object)profileName));
            this.profileItem.setToolTipText(NLS.bind((String)"Active profile is ''{0}''", (Object)profileName));
        } else {
            this.profileItem.setText("No profile");
            this.profileItem.setToolTipText("No active profile is set");
        }
        this.updateFolderToolbar();
    }

    private void updateFolderToolbar() {
        try {
            Method method = CTabFolder.class.getDeclaredMethod("updateFolder", Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.tabFolder, 8);
        }
        catch (ReflectiveOperationException e) {
            log.error((Object)"Can't update folder toolbar", (Throwable)e);
        }
    }

    private boolean unselectProfile(@Nullable DBWHandlerDescriptor handlerToKeep) {
        if (this.getActiveProfile() == null) {
            return true;
        }
        HashSet<NetworkHandlerDescriptor> handlersToRemove = new HashSet<NetworkHandlerDescriptor>();
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem cTabItem = cTabItemArray[n2];
            Object object = cTabItem.getData();
            if (object instanceof ConnectionPageNetworkHandler) {
                ConnectionPageNetworkHandler page = (ConnectionPageNetworkHandler)((Object)object);
                handlersToRemove.add(page.getHandlerDescriptor());
            }
            ++n2;
        }
        handlersToRemove.remove(handlerToKeep);
        if (!handlersToRemove.isEmpty()) {
            Reply reply = MessageBoxBuilder.builder().setTitle("Change profile").setMessage(NLS.bind((String)"Do you want to keep {0} after unselecting the active profile?", (Object)handlersToRemove.stream().map(DBWHandlerDescriptor::getCodeName).collect(Collectors.joining(", ")))).setPrimaryImage((DBPImage)DBIcon.STATUS_QUESTION).setReplies(new Reply[]{REPLY_KEEP, REPLY_REMOVE, Reply.CANCEL}).setDefaultReply(Reply.CANCEL).showMessageBox();
            if (reply == REPLY_KEEP) {
                handlersToRemove.clear();
            } else if (reply != REPLY_REMOVE) {
                return false;
            }
        }
        this.selectProfile0(null);
        for (DBWHandlerDescriptor dBWHandlerDescriptor : handlersToRemove) {
            this.removeHandler(dBWHandlerDescriptor);
        }
        this.refreshHandlers(null);
        this.updateProfileItem();
        return true;
    }

    private boolean selectProfile(@NotNull DBWNetworkProfile profile) {
        HashSet<NetworkHandlerDescriptor> handlersToRemove = new HashSet<NetworkHandlerDescriptor>();
        HashSet<DBWHandlerDescriptor> handlersToAdd = new HashSet<DBWHandlerDescriptor>();
        for (DBWHandlerConfiguration dBWHandlerConfiguration : profile.getConfigurations()) {
            if (!dBWHandlerConfiguration.isEnabled()) continue;
            handlersToAdd.add(dBWHandlerConfiguration.getHandlerDescriptor());
        }
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem cTabItem = cTabItemArray[n2];
            Object object = cTabItem.getData();
            if (object instanceof ConnectionPageNetworkHandler) {
                ConnectionPageNetworkHandler page = (ConnectionPageNetworkHandler)((Object)object);
                NetworkHandlerDescriptor descriptor = page.getHandlerDescriptor();
                if (handlersToAdd.contains(descriptor)) {
                    handlersToAdd.remove(descriptor);
                } else {
                    handlersToRemove.add(descriptor);
                }
            }
            ++n2;
        }
        if (!handlersToRemove.isEmpty()) {
            String string = NLS.bind((String)"Changing the profile to ''{0}'' will remove {1}.\n\nDo you want to continue?", (Object)profile.getProfileName(), (Object)handlersToRemove.stream().map(DBWHandlerDescriptor::getCodeName).collect(Collectors.joining(", ")));
            if (!UIUtils.confirmAction((Shell)this.getShell(), (String)"Change profile", (String)string)) {
                return false;
            }
        }
        for (DBWHandlerDescriptor dBWHandlerDescriptor : handlersToRemove) {
            this.removeHandler(dBWHandlerDescriptor);
        }
        this.selectProfile0(profile);
        for (DBWHandlerDescriptor dBWHandlerDescriptor : handlersToAdd) {
            this.addHandler(dBWHandlerDescriptor, profile);
        }
        this.refreshHandlers(profile);
        this.updateProfileItem();
        return true;
    }

    private void selectProfile0(@Nullable DBWNetworkProfile profile) {
        this.getActiveDataSource().getConnectionConfiguration().setConfigProfile(profile);
    }

    private void addHandler(@NotNull DBWHandlerDescriptor descriptor, @Nullable DBWNetworkProfile profile) {
        if (this.findHandlerItem(descriptor) != null) {
            log.error((Object)("Handler " + String.valueOf(descriptor) + " is already enabled"));
            return;
        }
        ConnectionPageNetworkHandler page = this.findHandlerPage(descriptor);
        if (page == null) {
            log.error((Object)("Can't find page for handler " + String.valueOf(descriptor)));
            return;
        }
        page.loadConfiguration(profile);
        page.getHandlerConfiguration().setEnabled(true);
        int index = Math.min(this.tabFolder.getItemCount(), ArrayUtils.indexOf((Object[])this.subPages, (Object)((Object)page)) + 1);
        CTabItem item = this.createPageTab((IDialogPage)page, index);
        this.activateItem(item);
    }

    private void removeHandler(@NotNull DBWHandlerDescriptor descriptor) {
        CTabItem item = this.findHandlerItem(descriptor);
        if (item == null) {
            log.error((Object)("Can't find page item for handler " + String.valueOf(descriptor)));
            return;
        }
        ConnectionPageNetworkHandler page = (ConnectionPageNetworkHandler)((Object)item.getData());
        page.loadConfiguration(null);
        page.getHandlerConfiguration().setEnabled(false);
        this.activateItem(item);
        item.dispose();
    }

    private void refreshHandlers(@Nullable DBWNetworkProfile profile) {
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            Object object = item.getData();
            if (object instanceof ConnectionPageNetworkHandler) {
                ConnectionPageNetworkHandler page = (ConnectionPageNetworkHandler)((Object)object);
                this.refreshHandler((DBWHandlerDescriptor)page.getHandlerDescriptor(), profile);
            }
            ++n2;
        }
    }

    private void refreshHandler(@NotNull DBWHandlerDescriptor descriptor, @Nullable DBWNetworkProfile profile) {
        CTabItem item = this.findHandlerItem(descriptor);
        if (item == null) {
            log.error((Object)("Can't find page item for handler " + String.valueOf(descriptor)));
            return;
        }
        this.activateItem(item);
        ConnectionPageNetworkHandler page = (ConnectionPageNetworkHandler)((Object)item.getData());
        page.refreshConfiguration(profile);
    }

    @Nullable
    private CTabItem findHandlerItem(@NotNull DBWHandlerDescriptor descriptor) {
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionPageNetworkHandler page;
            CTabItem it = cTabItemArray[n2];
            Object object = it.getData();
            if (object instanceof ConnectionPageNetworkHandler && (page = (ConnectionPageNetworkHandler)((Object)object)).getHandlerDescriptor() == descriptor) {
                return it;
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    private ConnectionPageNetworkHandler findHandlerPage(@NotNull DBWHandlerDescriptor descriptor) {
        IDialogPage[] iDialogPageArray = this.subPages;
        int n = this.subPages.length;
        int n2 = 0;
        while (n2 < n) {
            ConnectionPageNetworkHandler page;
            IDialogPage subPage = iDialogPageArray[n2];
            if (subPage instanceof ConnectionPageNetworkHandler && (page = (ConnectionPageNetworkHandler)subPage).getHandlerDescriptor() == descriptor) {
                return page;
            }
            ++n2;
        }
        return null;
    }

    private boolean closeTab(@NotNull CTabItem item) {
        ConnectionPageNetworkHandler page;
        NetworkHandlerDescriptor descriptor;
        if (item.getShowClose() && this.tabFolder.getSelection() == item && this.confirmTabClose(item) && this.unselectProfile((DBWHandlerDescriptor)(descriptor = (page = (ConnectionPageNetworkHandler)((Object)item.getData())).getHandlerDescriptor()))) {
            this.removeHandler((DBWHandlerDescriptor)descriptor);
            this.updateProfileItem();
            return true;
        }
        return false;
    }

    private boolean confirmTabClose(@NotNull CTabItem item) {
        Object object = item.getData();
        if (object instanceof ConnectionPageNetworkHandler) {
            ConnectionPageNetworkHandler page = (ConnectionPageNetworkHandler)((Object)object);
            NetworkHandlerDescriptor descriptor = page.getHandlerDescriptor();
            int decision = ConfirmationDialog.confirmAction((Shell)this.getShell(), (int)2, (String)"disable_network_handler", (int)5, (Object[])new Object[]{descriptor.getCodeName()});
            return decision == 0;
        }
        return false;
    }

    private boolean hasHandlersToAdd(@NotNull List<IDialogPage> pages) {
        for (IDialogPage page : pages) {
            if (!this.canAddHandler(page)) continue;
            return true;
        }
        return false;
    }

    private boolean canAddHandler(@NotNull IDialogPage page) {
        if (!ConnectionPageSettings.isHandlerPage(page)) {
            return false;
        }
        NetworkHandlerDescriptor descriptor = ((ConnectionPageNetworkHandler)page).getHandlerDescriptor();
        DBPConnectionConfiguration configuration = this.getActiveDataSource().getConnectionConfiguration();
        DBWHandlerConfiguration handler = configuration.getHandler(descriptor.getId());
        return handler == null || !handler.isEnabled();
    }

    private static boolean isHandlerPage(@NotNull IDialogPage page) {
        return page instanceof ConnectionPageNetworkHandler;
    }

    @NotNull
    private CTabItem createPageTab(@NotNull IDialogPage page, int index) {
        CTabItem item = new CTabItem(this.tabFolder, ConnectionPageSettings.isHandlerPage(page) ? 64 : 0, index);
        item.setData((Object)page);
        item.setText(CommonUtils.isEmpty((String)page.getTitle()) ? CoreMessages.dialog_setting_connection_general : page.getTitle());
        item.setToolTipText(page.getDescription());
        if (page.getControl() == null) {
            item.setControl((Control)UIUtils.createScrolledComposite((Composite)this.tabFolder, (int)768));
        } else {
            item.setControl((Control)page.getControl().getParent());
        }
        return item;
    }

    private void activateItem(@NotNull CTabItem item) {
        this.tabFolder.setSelection(item);
        this.activateCurrentItem();
    }

    private void activateCurrentItem() {
        CTabItem selection;
        if (this.tabFolder != null && (selection = this.tabFolder.getSelection()) != null) {
            IDialogPage page;
            block7: {
                page = (IDialogPage)selection.getData();
                if (page.getControl() == null) {
                    ScrolledComposite panel = (ScrolledComposite)selection.getControl();
                    panel.setRedraw(false);
                    try {
                        try {
                            page.createControl((Composite)panel);
                            Dialog.applyDialogFont((Control)panel);
                            UIUtils.configureScrolledComposite((ScrolledComposite)panel, (Control)page.getControl());
                            panel.layout(true, true);
                            panel.setMinSize(panel.computeSize(-1, -1));
                        }
                        catch (Throwable e) {
                            DBWorkbench.getPlatformUI().showError("Error creating configuration page", null, e);
                            panel.setRedraw(true);
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        panel.setRedraw(true);
                        throw throwable;
                    }
                    panel.setRedraw(true);
                }
            }
            page.setVisible(true);
            this.updatePageCompletion();
        }
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    protected void updatePageCompletion() {
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            block8: {
                boolean complete;
                IDialogPage page;
                CTabItem item;
                block7: {
                    block6: {
                        item = cTabItemArray[n2];
                        page = (IDialogPage)item.getData();
                        Object object = item.getData();
                        if (!(object instanceof IWizardPage)) break block6;
                        IWizardPage p = (IWizardPage)object;
                        complete = p.isPageComplete();
                        break block7;
                    }
                    Object object = item.getData();
                    if (!(object instanceof IDataSourceConnectionEditor)) break block8;
                    IDataSourceConnectionEditor p = (IDataSourceConnectionEditor)object;
                    complete = p.isComplete();
                }
                if (complete || this.tabFolder.getSelection() == item) {
                    item.setImage(null);
                    item.setToolTipText(page.getDescription());
                } else {
                    item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.SMALL_ERROR));
                    item.setToolTipText(Objects.requireNonNullElse(page.getErrorMessage(), "Page is incomplete"));
                }
            }
            ++n2;
        }
        super.updatePageCompletion();
    }

    public boolean isPageComplete() {
        if (this.subPages != null) {
            IDialogPage[] iDialogPageArray = this.subPages;
            int n = this.subPages.length;
            int n2 = 0;
            while (n2 < n) {
                IDataSourceConnectionEditor editor;
                IWizardPage wizardPage;
                IDialogPage page = iDialogPageArray[n2];
                if (page instanceof IWizardPage && !(wizardPage = (IWizardPage)page).isPageComplete()) {
                    return false;
                }
                if (page instanceof IDataSourceConnectionEditor && !(editor = (IDataSourceConnectionEditor)page).isComplete()) {
                    return false;
                }
                ++n2;
            }
        }
        return this.wizard.getPageSettings() != this || this.connectionEditor != null && (this.connectionEditor.isExternalConfigurationProvided() || this.connectionEditor.isComplete());
    }

    public String getErrorMessage() {
        if (this.isTemporaryConnection()) {
            return "Temporary data source (changes won't be saved)";
        }
        IDialogPage subPage = this.getCurrentSubPage();
        if (subPage != null && subPage.getErrorMessage() != null) {
            return subPage.getErrorMessage();
        }
        if (this.connectionEditor != null && this.connectionEditor.getErrorMessage() != null) {
            return this.connectionEditor.getErrorMessage();
        }
        return super.getErrorMessage();
    }

    private boolean isTemporaryConnection() {
        DataSourceDescriptor originalDataSource = this.wizard.getOriginalDataSource();
        return originalDataSource != null && originalDataSource.isTemporary();
    }

    public DBRRunnableContext getRunnableContext() {
        return this.wizard.getRunnableContext();
    }

    public DBPDataSourceRegistry getDataSourceRegistry() {
        return this.wizard.getDataSourceRegistry();
    }

    public boolean isNew() {
        return this.wizard.isNew();
    }

    public DBPDriver getDriver() {
        return this.wizard.getSelectedDriver();
    }

    @NotNull
    public DataSourceDescriptor getActiveDataSource() {
        return this.wizard.getActiveDataSource();
    }

    public void updateButtons() {
        this.updatePageCompletion();
    }

    public boolean openDriverEditor() {
        DriverEditDialog dialog = new DriverEditDialog(this.wizard.getShell(), (DBPDriver)((DriverDescriptor)this.getDriver()));
        return dialog.open() == 0;
    }

    public boolean openSettingsPage(String pageId) {
        return this.wizard.openSettingsPage(pageId);
    }

    public void testConnection() {
        ((ConnectionWizard)this.getWizard()).testConnection();
    }

    public RCPProject getProject() {
        DBPDataSourceRegistry registry = this.wizard.getDataSourceRegistry();
        return registry == null ? null : (RCPProject)registry.getProject();
    }

    public void firePropertyChange(Object source, String property, Object oldValue, Object newValue) {
        PropertyChangeEvent pcEvent = new PropertyChangeEvent(source, property, oldValue, newValue);
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            IDialogPage page = (IDialogPage)item.getData();
            if (page instanceof IPropertyChangeListener && page.getControl() != null) {
                ((IPropertyChangeListener)page).propertyChange(pcEvent);
            }
            ++n2;
        }
        cTabItemArray = ((ConnectionWizard)this.getWizard()).getPages();
        n = cTabItemArray.length;
        n2 = 0;
        while (n2 < n) {
            CTabItem page = cTabItemArray[n2];
            if (page instanceof IPropertyChangeListener && page.getControl() != null) {
                ((IPropertyChangeListener)page).propertyChange(pcEvent);
            }
            ++n2;
        }
    }

    public void dispose() {
        if (this.connectionEditor != null) {
            this.connectionEditor.dispose();
            this.connectionEditor = null;
        }
        if (this.extraPages != null) {
            IDialogPage[] iDialogPageArray = this.extraPages;
            int n = this.extraPages.length;
            int n2 = 0;
            while (n2 < n) {
                IDialogPage ep = iDialogPageArray[n2];
                ep.dispose();
                ++n2;
            }
            this.extraPages = null;
        }
        super.dispose();
    }

    @Nullable
    public IDialogPage[] getDialogPages(boolean extrasOnly, boolean forceCreate) {
        if (extrasOnly) {
            return this.extraPages;
        }
        if (this.subPages != null) {
            return this.subPages;
        }
        if (!forceCreate) {
            return new IDialogPage[0];
        }
        IDataSourceConnectionEditor originalConnectionEditor = this.getOriginalConnectionEditor();
        if (originalConnectionEditor instanceof IDialogPageProvider) {
            this.subPages = ((IDialogPageProvider)originalConnectionEditor).getDialogPages(extrasOnly, true);
            if (!(this.getDriver().isEmbedded() && !CommonUtils.toBoolean((Object)this.getDriver().getDriverParameter("enableNetworkParameters")) || CommonUtils.toBoolean((Object)this.getDriver().getDriverParameter("disableNetworkParameters")))) {
                for (NetworkHandlerDescriptor descriptor : NetworkHandlerRegistry.getInstance().getDescriptors((DBPDataSourceContainer)this.getActiveDataSource())) {
                    if (this.driverSubstitution != null && !this.driverSubstitution.getInstance().isNetworkHandlerSupported((DBWHandlerDescriptor)descriptor)) continue;
                    this.subPages = (IDialogPage[])ArrayUtils.add(IDialogPage.class, (Object[])this.subPages, (Object)((Object)new ConnectionPageNetworkHandler(this, descriptor)));
                }
            }
            if (this.extraPages != null) {
                this.subPages = (IDialogPage[])ArrayUtils.concatArrays((Object[])this.subPages, (Object[])this.extraPages);
            }
            try {
                IDialogPage[] dialogPages;
                IDialogPageProvider externalPagesProvider = (IDialogPageProvider)GeneralUtils.adapt((Object)this.getActiveDataSource(), IDialogPageProvider.class);
                if (externalPagesProvider != null && (dialogPages = externalPagesProvider.getDialogPages(false, true)) != null) {
                    IDialogPage[] iDialogPageArray = dialogPages;
                    int n = dialogPages.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDialogPage page = iDialogPageArray[n2];
                        if (page != null) {
                            this.subPages = (IDialogPage[])ArrayUtils.add(IDialogPage.class, (Object[])this.subPages, (Object)page);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
            if (!ArrayUtils.isEmpty((Object[])this.subPages)) {
                IDialogPage[] iDialogPageArray = this.subPages;
                int n = this.subPages.length;
                int n3 = 0;
                while (n3 < n) {
                    IDialogPage page = iDialogPageArray[n3];
                    if (page instanceof IDataSourceConnectionEditor) {
                        IDataSourceConnectionEditor p = (IDataSourceConnectionEditor)page;
                        p.setSite((IDataSourceConnectionEditorSite)this);
                    }
                    if (page instanceof IWizardPage) {
                        IWizardPage p = (IWizardPage)page;
                        p.setWizard(this.getWizard());
                    }
                    ++n3;
                }
            }
            return this.subPages;
        }
        return this.extraPages;
    }

    public void addSubPage(IDialogPage page) {
        this.extraPages = this.extraPages == null ? new IDialogPage[]{page} : (IDialogPage[])ArrayUtils.concatArrays((Object[])this.extraPages, (Object[])new IDialogPage[]{page});
        if (page instanceof IWizardPage) {
            ((IWizardPage)page).setWizard(this.getWizard());
        }
    }

    public void testConnection(DBCSession session) {
        if (this.connectionEditor instanceof IDataSourceConnectionTester) {
            ((IDataSourceConnectionTester)this.connectionEditor).testConnection(session);
        }
    }

    public String toString() {
        return this.getName();
    }

    public void showSubPage(IDialogPage subPage) {
        CTabItem selection = this.tabFolder.getSelection();
        CTabItem[] cTabItemArray = this.tabFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem pageTab = cTabItemArray[n2];
            if (pageTab.getData() == subPage) {
                this.activateItem(pageTab);
                if (selection != null && selection.getData() != subPage && selection.getData() instanceof ActiveWizardPage) {
                    ((ActiveWizardPage)selection.getData()).deactivatePage();
                }
                if (!(subPage instanceof ActiveWizardPage)) break;
                ((ActiveWizardPage)subPage).activatePage();
                break;
            }
            ++n2;
        }
    }

    @Nullable
    public IDialogPage getCurrentSubPage() {
        CTabItem selection = this.tabFolder.getSelection();
        return selection != null ? (IDialogPage)selection.getData() : null;
    }

    @Nullable
    private DBWNetworkProfile getActiveProfile() {
        DataSourceDescriptor dataSource = this.getActiveDataSource();
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        if (CommonUtils.isEmpty((String)configuration.getConfigProfileName())) {
            return null;
        }
        return dataSource.getRegistry().getNetworkProfile(configuration.getConfigProfileSource(), configuration.getConfigProfileName());
    }

    private class AddHandlerAction
    extends Action {
        private final DBWHandlerDescriptor descriptor;

        public AddHandlerAction(DBWHandlerDescriptor descriptor) {
            super(descriptor.getCodeName(), 1);
            this.descriptor = descriptor;
        }

        public void run() {
            if (ConnectionPageSettings.this.unselectProfile(this.descriptor)) {
                ConnectionPageSettings.this.addHandler(this.descriptor, null);
                ConnectionPageSettings.this.refreshHandler(this.descriptor, null);
                ConnectionPageSettings.this.updateProfileItem();
            }
        }
    }

    private class ChooseNetworkProfileAction
    extends Action {
        private final DBWNetworkProfile profile;

        public ChooseNetworkProfileAction() {
            super("None", 8);
            this.profile = null;
        }

        public ChooseNetworkProfileAction(@NotNull DBPDataSourceContainer container, @Nullable DBWNetworkProfile profile, DBPDataSourceOrigin origin, int index) {
            super(null, 8);
            this.profile = profile;
            this.setText(ActionUtils.getLabelWithIndexMnemonic((String)ChooseNetworkProfileAction.getProfileName(profile, origin), (int)index));
            this.setChecked(ChooseNetworkProfileAction.isProfileSelected(profile, container));
        }

        public void run() {
            if (!this.isChecked()) {
                return;
            }
            if (this.profile != null) {
                ConnectionPageSettings.this.selectProfile(this.profile);
            } else {
                ConnectionPageSettings.this.unselectProfile(null);
            }
        }

        @NotNull
        private static String getProfileName(@NotNull DBWNetworkProfile profile, @Nullable DBPDataSourceOrigin origin) {
            if (origin != null) {
                return NLS.bind((String)"{0} {1}", (Object)profile.getProfileName(), (Object)origin.getDisplayName());
            }
            return profile.getProfileName();
        }

        private static boolean isProfileSelected(@NotNull DBWNetworkProfile profile, @NotNull DBPDataSourceContainer container) {
            DBPConnectionConfiguration config = container.getConnectionConfiguration();
            if (CommonUtils.isEmptyTrimmed((String)config.getConfigProfileName())) {
                return false;
            }
            return Objects.equals(profile.getProfileName(), config.getConfigProfileName()) && Objects.equals(profile.getProfileSource(), config.getConfigProfileSource());
        }
    }
}

