/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.formatter;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.WorkspaceConfigEventManager;
import org.jkiss.dbeaver.model.app.DBPDataFormatterRegistry;
import org.jkiss.dbeaver.model.data.DBDDataFormatterProfile;
import org.jkiss.dbeaver.model.impl.preferences.SimplePreferenceStore;
import org.jkiss.dbeaver.registry.formatter.DataFormatterDescriptor;
import org.jkiss.dbeaver.registry.formatter.DataFormatterProfile;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.xml.SAXListener;
import org.jkiss.utils.xml.SAXReader;
import org.jkiss.utils.xml.XMLBuilder;
import org.jkiss.utils.xml.XMLException;
import org.xml.sax.Attributes;

public class DataFormatterRegistry
implements DBPDataFormatterRegistry {
    private static final Log log = Log.getLog(DataFormatterRegistry.class);
    public static final String CONFIG_FILE_NAME = "dataformat-profiles.xml";
    private static DataFormatterRegistry instance = null;
    private final List<DataFormatterDescriptor> dataFormatterList = new ArrayList<DataFormatterDescriptor>();
    private final Map<String, DataFormatterDescriptor> dataFormatterMap = new HashMap<String, DataFormatterDescriptor>();
    private DBDDataFormatterProfile globalProfile;
    private List<DBDDataFormatterProfile> customProfiles = null;

    public static synchronized DataFormatterRegistry getInstance() {
        if (instance == null) {
            instance = new DataFormatterRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private DataFormatterRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.dataFormatter");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            DataFormatterDescriptor formatterDescriptor = new DataFormatterDescriptor(ext);
            this.dataFormatterList.add(formatterDescriptor);
            this.dataFormatterMap.put(formatterDescriptor.getId(), formatterDescriptor);
            ++n2;
        }
    }

    public void dispose() {
        this.dataFormatterList.clear();
        this.dataFormatterMap.clear();
        this.globalProfile = null;
    }

    public List<DataFormatterDescriptor> getDataFormatters() {
        return this.dataFormatterList;
    }

    public DataFormatterDescriptor getDataFormatter(String typeId) {
        return this.dataFormatterMap.get(typeId);
    }

    @Override
    @NotNull
    public synchronized DBDDataFormatterProfile getGlobalProfile() {
        if (this.globalProfile == null) {
            this.globalProfile = new DataFormatterProfile("Global", DBWorkbench.getPlatform().getPreferenceStore());
        }
        return this.globalProfile;
    }

    @Override
    @Nullable
    public synchronized DBDDataFormatterProfile getCustomProfile(@NotNull String name) {
        for (DBDDataFormatterProfile profile : this.getCustomProfilesInternal()) {
            if (!profile.getProfileName().equals(name)) continue;
            return profile;
        }
        return null;
    }

    @Override
    @NotNull
    public synchronized List<DBDDataFormatterProfile> getCustomProfiles() {
        return List.copyOf(this.getCustomProfilesInternal());
    }

    private synchronized List<DBDDataFormatterProfile> getCustomProfilesInternal() {
        if (this.customProfiles == null) {
            this.loadProfiles();
            WorkspaceConfigEventManager.addConfigChangedListener(CONFIG_FILE_NAME, o -> this.loadProfiles());
        }
        return this.customProfiles;
    }

    private synchronized void loadProfiles() {
        this.customProfiles = new ArrayList<DBDDataFormatterProfile>();
        try {
            String content = DBWorkbench.getPlatform().getProductConfigurationController().loadConfigurationFile(CONFIG_FILE_NAME);
            if (CommonUtils.isEmpty((String)content)) {
                return;
            }
            Throwable throwable = null;
            Object var3_5 = null;
            try (StringReader is = new StringReader(content);){
                SAXReader parser = new SAXReader((Reader)is);
                try {
                    parser.parse((SAXListener)new FormattersParser());
                }
                catch (Throwable ex) {
                    throw new DBException("Datasource config parse error", ex);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (DBException ex) {
            log.warn("Can't load profiles config from dataformat-profiles.xml", ex);
        }
    }

    private synchronized void saveProfiles() {
        if (this.customProfiles == null) {
            return;
        }
        if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
            log.warn("The user has no permission to save data formatter configuration");
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (StringWriter out = new StringWriter();){
                XMLBuilder xml = new XMLBuilder((Writer)out, GeneralUtils.UTF8_ENCODING);
                xml.setBeautify(true);
                xml.startElement("profiles");
                for (DBDDataFormatterProfile profile : this.customProfiles) {
                    xml.startElement("profile");
                    xml.addAttribute("name", profile.getProfileName());
                    SimplePreferenceStore store = (SimplePreferenceStore)profile.getPreferenceStore();
                    Map<String, String> props = store.getProperties();
                    if (props != null) {
                        for (Map.Entry<String, String> entry : props.entrySet()) {
                            xml.startElement("property");
                            xml.addAttribute("name", entry.getKey());
                            xml.addAttribute("value", entry.getValue());
                            xml.endElement();
                        }
                    }
                    xml.endElement();
                }
                xml.endElement();
                xml.flush();
                out.flush();
                DBWorkbench.getPlatform().getProductConfigurationController().saveConfigurationFile(CONFIG_FILE_NAME, out.getBuffer().toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable ex) {
            log.warn("Failed to save data formatter profiles to dataformat-profiles.xml", ex);
        }
    }

    public synchronized DBDDataFormatterProfile createCustomProfile(String profileName) {
        this.getCustomProfilesInternal();
        DataFormatterProfile profile = new DataFormatterProfile(profileName, new CustomProfileStore());
        this.customProfiles.add(profile);
        this.saveProfiles();
        return profile;
    }

    public synchronized void deleteCustomProfile(DBDDataFormatterProfile profile) {
        this.getCustomProfilesInternal();
        if (this.customProfiles.remove(profile)) {
            this.saveProfiles();
        }
    }

    private class CustomProfileStore
    extends SimplePreferenceStore {
        private CustomProfileStore() {
            super(DBWorkbench.getPlatform().getPreferenceStore());
        }

        @Override
        public void save() throws IOException {
            DataFormatterRegistry.this.saveProfiles();
        }
    }

    private class FormattersParser
    extends SAXListener.BaseListener {
        private String profileName;
        private SimplePreferenceStore curStore;

        private FormattersParser() {
        }

        public void saxStartElement(SAXReader reader, String namespaceURI, String localName, Attributes atts) throws XMLException {
            if (localName.equals("profile")) {
                this.curStore = new CustomProfileStore();
                this.profileName = atts.getValue("name");
            } else if (localName.equals("property") && this.curStore != null) {
                this.curStore.setValue(atts.getValue("name"), atts.getValue("value"));
            }
        }

        public void saxEndElement(SAXReader reader, String namespaceURI, String localName) throws XMLException {
            if (localName.equals("profile") && !CommonUtils.isEmpty((String)this.profileName)) {
                DataFormatterProfile profile = new DataFormatterProfile(this.profileName, this.curStore);
                DataFormatterRegistry.this.customProfiles.add(profile);
            }
        }
    }
}

