/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.databricks.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.databricks.DatabricksDataSource;
import org.jkiss.dbeaver.ext.databricks.model.DatabricksSchema;
import org.jkiss.dbeaver.ext.databricks.model.DatabricksTable;
import org.jkiss.dbeaver.ext.databricks.model.DatabricksView;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericView;
import org.jkiss.dbeaver.ext.generic.model.meta.GenericMetaModel;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformProvider;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.sql.QueryTransformerLimit;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.utils.CommonUtils;

public class DatabricksMetaModel
extends GenericMetaModel
implements DBCQueryTransformProvider {
    private static final Log log = Log.getLog(DatabricksMetaModel.class);
    private List<ViewInfo> tempViewsList = new ArrayList<ViewInfo>();

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            return new QueryTransformerLimit(false, false);
        }
        return null;
    }

    @NotNull
    public GenericDataSource createDataSourceImpl(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new DatabricksDataSource(monitor, container, this);
    }

    public GenericSchema createSchemaImpl(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName) {
        return new DatabricksSchema(dataSource, catalog, schemaName);
    }

    @Nullable
    public List<GenericSchema> loadSchemas(JDBCSession session, GenericDataSource dataSource, GenericCatalog catalog) throws DBException {
        ArrayList<GenericSchema> schemas = new ArrayList<GenericSchema>();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCPreparedStatement dbStat = session.prepareStatement("SHOW SCHEMAS IN " + catalog.getName());){
                dbStat.executeStatement();
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (JDBCResultSet dbResult = dbStat.getResultSet();){
                    while (dbResult.next()) {
                        String schemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"databaseName");
                        schemas.add(new DatabricksSchema(dataSource, catalog, schemaName));
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Cannot load schemas with query", (Throwable)e);
            return super.loadSchemas(session, dataSource, catalog);
        }
        return schemas;
    }

    public boolean isSystemSchema(GenericSchema schema) {
        return "global_temp".equals(schema.getName()) || "information_schema".equalsIgnoreCase(schema.getName());
    }

    public JDBCStatement prepareTableLoadStatement(@NotNull JDBCSession session, @NotNull GenericStructContainer owner, @Nullable GenericTableBase object, @Nullable String objectName) throws SQLException {
        block72: {
            DBSCatalog originalCatalog = null;
            try {
                DBCExecutionContextDefaults contextDefaults = session.getExecutionContext().getContextDefaults();
                if (contextDefaults != null) {
                    originalCatalog = contextDefaults.getDefaultCatalog();
                    if (contextDefaults.getDefaultCatalog() == null) {
                        contextDefaults.setDefaultCatalog(session.getProgressMonitor(), (DBSCatalog)owner.getCatalog(), null);
                    }
                }
            }
            catch (DBCException e) {
                log.debug((Object)"Can't read current views list", (Throwable)e);
            }
            try {
                try {
                    Throwable e = null;
                    Object var7_10 = null;
                    try (JDBCStatement statement = session.createStatement();){
                        statement.execute("USE CATALOG " + DBUtils.getQuotedIdentifier((DBSObject)owner.getCatalog()));
                        Throwable throwable = null;
                        Object var10_15 = null;
                        try (JDBCPreparedStatement dbStat = session.prepareStatement("SHOW VIEWS IN " + DBUtils.getQuotedIdentifier((DBSObject)owner));){
                            Throwable throwable2 = null;
                            Object var13_20 = null;
                            try (JDBCResultSet dbResult = dbStat.executeQuery();){
                                while (dbResult.next()) {
                                    String viewName;
                                    String namespace = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"namespace");
                                    if (CommonUtils.isEmpty((String)namespace) || !CommonUtils.isNotEmpty((String)(viewName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"viewName")))) continue;
                                    this.tempViewsList.add(new ViewInfo(owner, viewName));
                                }
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable == null) {
                                throwable = throwable4;
                            } else if (throwable != throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (SQLException e) {
                    log.debug((Object)"Can't read current views list", (Throwable)e);
                    if (originalCatalog == null || originalCatalog == owner.getCatalog()) break block72;
                    try {
                        Throwable throwable = null;
                        Object var19_34 = null;
                        try (JDBCStatement statement = session.createStatement();){
                            statement.execute("USE CATALOG " + DBUtils.getQuotedIdentifier((DBSObject)originalCatalog));
                            break block72;
                        }
                        catch (Throwable throwable5) {
                            if (throwable == null) {
                                throwable = throwable5;
                            } else if (throwable != throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e2) {
                        log.debug((Object)"Can't restore original catalog", (Throwable)e2);
                    }
                    break block72;
                }
            }
            catch (Throwable throwable) {
                if (originalCatalog != null && originalCatalog != owner.getCatalog()) {
                    try {
                        Throwable e2 = null;
                        Object var19_36 = null;
                        try (JDBCStatement statement = session.createStatement();){
                            statement.execute("USE CATALOG " + DBUtils.getQuotedIdentifier((DBSObject)originalCatalog));
                        }
                        catch (Throwable throwable6) {
                            if (e2 == null) {
                                e2 = throwable6;
                            } else if (e2 != throwable6) {
                                e2.addSuppressed(throwable6);
                            }
                            throw e2;
                        }
                    }
                    catch (SQLException e) {
                        log.debug((Object)"Can't restore original catalog", (Throwable)e);
                    }
                }
                throw throwable;
            }
            if (originalCatalog != null && originalCatalog != owner.getCatalog()) {
                try {
                    Throwable e = null;
                    Object var19_38 = null;
                    try (JDBCStatement statement = session.createStatement();){
                        statement.execute("USE CATALOG " + DBUtils.getQuotedIdentifier((DBSObject)originalCatalog));
                    }
                    catch (Throwable throwable) {
                        if (e == null) {
                            e = throwable;
                        } else if (e != throwable) {
                            e.addSuppressed(throwable);
                        }
                        throw e;
                    }
                }
                catch (SQLException e) {
                    log.debug((Object)"Can't restore original catalog", (Throwable)e);
                }
            }
        }
        return super.prepareTableLoadStatement(session, owner, object, objectName);
    }

    public GenericTableBase createTableOrViewImpl(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        if (CommonUtils.isNotEmpty((String)tableName) && !this.tempViewsList.isEmpty() && this.tempViewsList.stream().anyMatch(e -> e.name.equalsIgnoreCase(tableName)) || tableType != null && this.isView(tableType)) {
            return new DatabricksView(container, tableName, tableType, dbResult);
        }
        return new DatabricksTable(container, tableName, tableType, dbResult);
    }

    public boolean supportsTableDDLSplit(@NotNull GenericTableBase sourceObject) {
        return false;
    }

    public boolean isTableCommentEditable() {
        return true;
    }

    /*
     * Exception decompiling
     */
    public String getTableDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericTableBase sourceObject, @NotNull Map<String, Object> options) throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String getViewDDL(@NotNull DBRProgressMonitor monitor, @NotNull GenericView sourceObject, @NotNull Map<String, Object> options) throws DBException {
        return this.getTableDDL(monitor, (GenericTableBase)sourceObject, options);
    }

    private static class ViewInfo {
        GenericStructContainer schema;
        String name;

        ViewInfo(GenericStructContainer schema, String name) {
            this.schema = schema;
            this.name = name;
        }
    }
}

