/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.completion;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPKeywordType;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.model.sql.completion.CompletionProposalBase;
import org.jkiss.dbeaver.model.sql.completion.SQLCompletionHelper;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionItemKind;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryCompletionProposalContext;
import org.jkiss.dbeaver.model.sql.semantics.completion.SQLQueryWordEntry;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLQueryCompletionProposal
extends CompletionProposalBase {
    private static final Log log = Log.getLog(SQLQueryCompletionProposal.class);
    protected static final boolean DEBUG = false;
    private final SQLQueryCompletionProposalContext proposalContext;
    protected final SQLQueryCompletionItemKind itemKind;
    protected final DBSObject object;
    protected final DBPImage image;
    protected final String displayString;
    protected final String decorationString;
    protected final String description;
    protected final String replacementString;
    protected final int replacementOffset;
    protected final int replacementLength;
    protected final SQLQueryWordEntry filterString;
    protected int proposalScore;
    protected boolean cachedProposalInfoComputed = false;
    protected Object cachedProposalInfo = null;

    public SQLQueryCompletionProposal(@NotNull SQLQueryCompletionProposalContext proposalContext, @NotNull SQLQueryCompletionItemKind itemKind, @Nullable DBSObject object, @Nullable DBPImage image, @Nullable String displayString, @Nullable String decorationString, @NotNull String description, @NotNull String replacementString, int replacementOffset, int replacementLength, @Nullable SQLQueryWordEntry filterString, int proposalScore) {
        this.proposalContext = proposalContext;
        this.itemKind = itemKind;
        this.object = object;
        this.image = image;
        this.displayString = displayString;
        this.decorationString = decorationString;
        this.description = description;
        this.replacementString = replacementString;
        this.replacementOffset = replacementOffset;
        this.replacementLength = replacementLength;
        this.filterString = filterString;
        this.proposalScore = proposalScore;
    }

    public SQLQueryCompletionItemKind getItemKind() {
        return this.itemKind;
    }

    @Override
    public int getReplacementOffset() {
        return this.replacementOffset;
    }

    @Override
    public int getReplacementLength() {
        return this.replacementLength;
    }

    @Override
    public String getReplacementString() {
        return this.displayString;
    }

    @Override
    public int getProposalScore() {
        return this.proposalScore;
    }

    @Override
    public DBPImage getObjectImage() {
        return this.image;
    }

    @NotNull
    public SQLQueryCompletionProposalContext getProposalContext() {
        return this.proposalContext;
    }

    @Override
    public String getDisplayString() {
        return CommonUtils.isNotEmpty((String)this.displayString) ? this.displayString : this.replacementString.replaceAll("[\r\n]", "");
    }

    @Override
    public DBPKeywordType getProposalType() {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return this.description;
    }

    public Object getAdditionalProposalInfo(IProgressMonitor progressMonitor) {
        if (!this.getProposalContext().getActivityTracker().isAdditionalInfoExpected()) {
            return this.description;
        }
        if (!this.cachedProposalInfoComputed) {
            DefaultProgressMonitor monitor = new DefaultProgressMonitor(progressMonitor);
            if (this.object != null) {
                DBNModel navModel = this.object.getDataSource().getContainer().getProject().getNavigatorModel();
                if (navModel != null) {
                    navModel.getNodeByObject((DBRProgressMonitor)monitor, this.object, true);
                }
                this.cachedProposalInfo = this.object;
            } else {
                String info;
                this.cachedProposalInfo = this.itemKind == SQLQueryCompletionItemKind.RESERVED ? ((info = SQLCompletionHelper.readAdditionalProposalInfo((DBRProgressMonitor)monitor, this.proposalContext.getCompletionContext(), (DBPNamedObject)this.object, new String[]{this.getDisplayString()}, DBPKeywordType.KEYWORD)) == null || info.equals(this.getDisplayString()) ? this.description : info) : this.description;
            }
            this.cachedProposalInfoComputed = true;
        }
        return this.cachedProposalInfo;
    }

    public boolean isAutoInsertable() {
        return true;
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.replacementString;
    }

    public int getPrefixCompletionStart(IDocument document, int completionOffset) {
        return this.replacementOffset;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.replacementOffset, this.replacementLength, this.replacementString);
        }
        catch (BadLocationException ex) {
            log.error((Object)"Error applying completion proposal", (Throwable)ex);
        }
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        this.getProposalContext().getActivityTracker().implicitlyTriggered();
        if (this.filterString != null && CommonUtils.isNotEmpty((String)this.filterString.filterString)) {
            int filterKeyStart;
            block5: {
                filterKeyStart = this.filterString.offset >= 0 ? this.filterString.offset : this.proposalContext.getRequestOffset();
                if (offset <= document.getLength()) break block5;
                return false;
            }
            try {
                int filterKeyLength = offset - filterKeyStart;
                if (filterKeyLength > 0) {
                    String filterKey = document.get(filterKeyStart, filterKeyLength);
                    this.proposalScore = this.filterString.matches(filterKey, this.proposalContext.getCompletionContext().isSearchInsideNames());
                    return this.proposalScore > 0;
                }
                this.proposalScore = Integer.MAX_VALUE;
                return true;
            }
            catch (BadLocationException ex) {
                log.error((Object)"Error validating completion proposal", (Throwable)ex);
            }
        }
        return true;
    }
}

