/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.schema;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.schema.SQLSchemaScriptSource;

public class ClassLoaderScriptSource
implements SQLSchemaScriptSource {
    private static final Log log = Log.getLog(ClassLoaderScriptSource.class);
    private final ClassLoader classLoader;
    private final String createScriptPath;
    private final String updateScriptPrefix;

    public ClassLoaderScriptSource(ClassLoader classLoader, String createScriptPath, String updateScriptPrefix) {
        this.classLoader = classLoader;
        this.createScriptPath = createScriptPath;
        this.updateScriptPrefix = updateScriptPrefix;
    }

    @Override
    @NotNull
    public Reader openSchemaCreateScript(@NotNull DBRProgressMonitor monitor) throws IOException, DBException {
        InputStream resource = this.classLoader.getResourceAsStream(this.createScriptPath);
        if (resource == null) {
            throw new IOException("Resource '" + this.createScriptPath + "' not found in " + this.classLoader.getClass().getName());
        }
        log.info((Object)("Reading migration file: '" + this.createScriptPath + "'"));
        return new InputStreamReader(resource);
    }

    @Override
    @Nullable
    public Reader openSchemaUpdateScript(@NotNull DBRProgressMonitor monitor, int versionNumber, @Nullable String specificPrefix) throws IOException, DBException {
        String migrationFileNameWithSpecificPrefix = this.updateScriptPrefix + versionNumber + "_" + specificPrefix + ".sql";
        InputStream resource = this.classLoader.getResourceAsStream(migrationFileNameWithSpecificPrefix);
        if (resource != null) {
            log.info((Object)("Reading migration file: '" + migrationFileNameWithSpecificPrefix + "'"));
            return new InputStreamReader(resource);
        }
        String migrationFileName = this.updateScriptPrefix + versionNumber + ".sql";
        resource = this.classLoader.getResourceAsStream(migrationFileName);
        if (resource != null) {
            log.info((Object)("Reading migration file: '" + migrationFileName + "'"));
            return new InputStreamReader(resource);
        }
        return null;
    }
}

