/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.jexl3.JexlContext;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPObjectWithOrdinalPosition;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNContainer;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseItem;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeItem;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableColumn;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.AlphanumericComparator;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DBNUtils {
    private static final Log log = Log.getLog(DBNUtils.class);

    public static DBNDatabaseNode getNodeByObject(DBSObject object) {
        DBNModel model = DBNUtils.getNavigatorModel(object);
        return model == null ? null : model.getNodeByObject(object);
    }

    @Nullable
    public static DBNModel getNavigatorModel(DBSObject object) {
        DBPProject project = DBUtils.getObjectOwnerProject(object);
        if (project == null) {
            return null;
        }
        return project.getNavigatorModel();
    }

    public static DBNDatabaseNode getNodeByObject(DBRProgressMonitor monitor, DBSObject object, boolean addFiltered) {
        DBNModel model = DBNUtils.getNavigatorModel(object);
        return model == null ? null : model.getNodeByObject(monitor, object, addFiltered);
    }

    public static DBNDatabaseNode getChildFolder(DBRProgressMonitor monitor, DBNDatabaseNode node, Class<?> folderType) {
        try {
            DBNDatabaseNode[] dBNDatabaseNodeArray = node.getChildren(monitor);
            int n = dBNDatabaseNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> objectClass;
                DBNDatabaseFolder folder;
                DBXTreeFolder meta;
                DBNDatabaseNode childNode = dBNDatabaseNodeArray[n2];
                if (childNode instanceof DBNDatabaseFolder && !CommonUtils.isEmpty((String)(meta = (folder = (DBNDatabaseFolder)childNode).getMeta()).getType()) && (objectClass = meta.getSource().getObjectClass(meta.getType())) != null && folderType.isAssignableFrom(objectClass)) {
                    return childNode;
                }
                ++n2;
            }
        }
        catch (DBException e) {
            log.error("Error reading child folder", e);
        }
        return null;
    }

    public static DBNNode[] getNodeChildrenFiltered(DBRProgressMonitor monitor, DBNNode node, boolean forTree) throws DBException {
        DBNNode[] children = node.getChildren(monitor);
        if (children != null && children.length > 0) {
            children = DBNUtils.filterNavigableChildren(children, forTree);
        }
        return children;
    }

    public static DBNNode[] filterNavigableChildren(DBNNode[] children, boolean forTree) {
        DBNNode[] result;
        if (ArrayUtils.isEmpty((Object[])children)) {
            return children;
        }
        if (forTree) {
            ArrayList<DBNNode> filtered = new ArrayList<DBNNode>();
            DBNNode[] dBNNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                DBNDatabaseNode dbNode;
                DBPHiddenObject hiddenObject;
                DBNNode node = dBNNodeArray[n2];
                if (!(node instanceof DBPHiddenObject && (hiddenObject = (DBPHiddenObject)((Object)node)).isHidden() || node instanceof DBNDatabaseNode && !(dbNode = (DBNDatabaseNode)node).getMeta().isNavigable())) {
                    filtered.add(node);
                }
                ++n2;
            }
            result = filtered.toArray(new DBNNode[0]);
        } else {
            result = children;
        }
        DBNUtils.sortNodes(result);
        return result;
    }

    private static void sortNodes(DBNNode[] children) {
        DBNDatabaseItem item;
        DBNDatabaseItem item2;
        if (children.length == 0) {
            return;
        }
        DBPPreferenceStore prefStore = DBWorkbench.getPlatform().getPreferenceStore();
        DBNNode firstChild = children[0];
        if (firstChild.getAdapter(Path.class) != null) {
            Arrays.sort(children, NodeFolderComparator.INSTANCE);
            return;
        }
        if (firstChild instanceof DBNContainer) {
            return;
        }
        if (firstChild instanceof DBNDatabaseItem && (item2 = (DBNDatabaseItem)firstChild).getObject() instanceof DBSTableColumn) {
            if (prefStore.getBoolean("navigator.sort.case.insensitive")) {
                Arrays.sort(children, NodeNameComparator.INSTANCE);
            }
            return;
        }
        if (firstChild instanceof DBNDatabaseItem && (item = (DBNDatabaseItem)firstChild).getObject() instanceof DBPObjectWithOrdinalPosition) {
            return;
        }
        Comparator<DBNNode> comparator = null;
        if (prefStore.getBoolean("navigator.sort.case.insensitive")) {
            comparator = NodeNameComparator.INSTANCE;
        }
        if (prefStore.getBoolean("navigator.sort.forlers.first") || DBNUtils.isMergedEntity(firstChild)) {
            comparator = NodeFolderComparator.INSTANCE.thenComparing((o1, o2) -> {
                if (o1 instanceof DBNContainer && o2 instanceof DBNContainer) {
                    return 0;
                }
                if (o1 instanceof DBNContainer) {
                    return 1;
                }
                if (o2 instanceof DBNContainer) {
                    return -1;
                }
                return AlphanumericComparator.getInstance().compare((CharSequence)o1.getNodeDisplayName(), (CharSequence)o2.getNodeDisplayName());
            });
        }
        if (comparator != null) {
            Arrays.sort(children, comparator);
        }
    }

    private static boolean isMergedEntity(DBNNode node) {
        DBNDatabaseNode dbNode;
        return node instanceof DBNDatabaseNode && (dbNode = (DBNDatabaseNode)node).getObject() instanceof DBSEntity && dbNode.getObject().getDataSource().getContainer().getNavigatorSettings().isMergeEntities();
    }

    public static boolean isDefaultElement(Object element) {
        if (element instanceof DBSWrapper) {
            DBCExecutionContextDefaults contextDefaults;
            DBCExecutionContext defaultContext;
            DBSWrapper wrapper = (DBSWrapper)element;
            DBSObject object = wrapper.getObject();
            if (object != null && (defaultContext = DBUtils.getDefaultContext(object.getDataSource(), false)) != null && (contextDefaults = defaultContext.getContextDefaults()) != null) {
                return Objects.equals(contextDefaults.getDefaultCatalog(), object) || Objects.equals(contextDefaults.getDefaultSchema(), object);
            }
        } else if (element instanceof DBNProject) {
            DBNProject nodeProject = (DBNProject)element;
            return nodeProject.getProject() == DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        }
        return false;
    }

    @NotNull
    public static String getLastNodePathSegment(@NotNull String path) {
        int divPos = path.lastIndexOf(47);
        return divPos == -1 ? path : path.substring(divPos + 1);
    }

    public static boolean isReadOnly(DBNNode node) {
        if (node instanceof DBNDatabaseNode) {
            DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
            if (!(node instanceof DBNDataSource) && !dbNode.getDataSourceContainer().hasModifyPermission(DBPDataSourcePermission.PERMISSION_EDIT_METADATA)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isFolderNode(DBNNode node) {
        return node.allowsChildren();
    }

    public static DBXTreeItem getValidItemsMeta(DBRProgressMonitor monitor, DBNDatabaseNode dbNode) throws DBException {
        DBXTreeNode dBXTreeNode;
        List<DBXTreeNode> childMetas;
        Class<?> expectedChildrenType;
        DBXTreeItem itemsMeta = dbNode.getItemsMeta();
        if (itemsMeta != null && itemsMeta.isOptional() && (expectedChildrenType = dbNode.getChildrenOrFolderClass(itemsMeta)) != null && (childMetas = itemsMeta.getChildren(dbNode)).size() == 1 && (dBXTreeNode = childMetas.get(0)) instanceof DBXTreeItem) {
            DBXTreeItem nestedMeta = (DBXTreeItem)dBXTreeNode;
            dbNode.getChildrenOrFolderClass(nestedMeta);
            DBNDatabaseNode[] nodeChildren = dbNode.getChildren(monitor);
            if (nodeChildren.length > 0 && !expectedChildrenType.isInstance(nodeChildren[0].getObject())) {
                itemsMeta = nestedMeta;
            }
        }
        return itemsMeta;
    }

    @Nullable
    public static <T> T getParentOfType(@NotNull Class<T> type, DBNNode node) {
        if (node == null) {
            return null;
        }
        DBNNode parent = node.getParentNode();
        while (parent != null) {
            if (type.isInstance(parent)) {
                return type.cast(parent);
            }
            if (parent instanceof DBNRoot) break;
            parent = parent.getParentNode();
        }
        return null;
    }

    public static JexlContext makeContext(final DBNNode node) {
        return new JexlContext(){

            public Object get(String name) {
                block14: {
                    if (!(node instanceof DBNDatabaseNode)) break block14;
                    switch (name) {
                        case "object": {
                            return ((DBNDatabaseNode)node).getValueObject();
                        }
                        case "dataSource": {
                            return ((DBNDatabaseNode)node).getDataSource();
                        }
                        case "connected": {
                            if (((DBNDatabaseNode)node).getDataSource() != null) {
                                return true;
                            }
                            return false;
                        }
                    }
                }
                return null;
            }

            public void set(String name, Object value) {
                log.warn("Set is not implemented in DBX model");
            }

            public boolean has(String name) {
                if (node instanceof DBNDatabaseNode) {
                    DBNDatabaseNode dbNode = (DBNDatabaseNode)node;
                    if (name.equals("object") && dbNode.getValueObject() != null) {
                        return true;
                    }
                }
                return false;
            }
        };
    }

    public static String decodeNodePath(@NotNull String nodePath) {
        return nodePath.replace("%2F", "/").replace("%25", "%");
    }

    public static String encodeNodePath(@NotNull String path) {
        return path.replace("%", "%25").replace("/", "%2F");
    }

    public static void disposeNode(DBNNode node, boolean reflect) {
        node.dispose(reflect);
    }

    @Nullable
    public static DBNDatabaseNode getDefaultDatabaseNodeToOpen(DBRProgressMonitor monitor, DBPDataSource dataSource) throws DBException {
        DBSObject objectToOpen;
        ArrayList<DBSEntity> entities = new ArrayList<DBSEntity>();
        if (dataSource instanceof DBSObjectContainer) {
            DBSObjectContainer container = (DBSObjectContainer)((Object)dataSource);
            DBNUtils.getConnectionEntities(monitor, container, entities);
        }
        if ((objectToOpen = entities.size() == 1 ? (DBSObject)entities.get(0) : (entities.size() > 1 ? ((DBSEntity)entities.get(0)).getParentObject() : dataSource)) == null) {
            throw new DBException("No entities found in file datasource");
        }
        return DBNUtils.getNodeByObject(monitor, objectToOpen, true);
    }

    private static void getConnectionEntities(DBRProgressMonitor monitor, DBSObjectContainer container, List<DBSEntity> entities) throws DBException {
        for (DBSObject dBSObject : container.getChildren(monitor)) {
            if (dBSObject instanceof DBSEntity) {
                DBSEntity entity = (DBSEntity)dBSObject;
                entities.add(entity);
                continue;
            }
            if (!(dBSObject instanceof DBSObjectContainer)) continue;
            DBSObjectContainer oc = (DBSObjectContainer)dBSObject;
            DBNUtils.getConnectionEntities(monitor, oc, entities);
        }
    }

    private static class NodeFolderComparator
    implements Comparator<DBNNode> {
        static final NodeFolderComparator INSTANCE = new NodeFolderComparator();

        private NodeFolderComparator() {
        }

        @Override
        public int compare(DBNNode node1, DBNNode node2) {
            int first = NodeFolderComparator.isFolderNode(node1) ? -1 : 1;
            int second = NodeFolderComparator.isFolderNode(node2) ? -1 : 1;
            return first - second;
        }

        private static boolean isFolderNode(DBNNode node) {
            DBNDatabaseNode dbn;
            if (node instanceof DBNDatabaseNode && (dbn = (DBNDatabaseNode)node).getObject() instanceof DBPObjectWithOrdinalPosition) {
                return false;
            }
            return node instanceof DBNContainer || node.allowsChildren();
        }
    }

    private static class NodeNameComparator
    implements Comparator<DBNNode> {
        static NodeNameComparator INSTANCE = new NodeNameComparator();

        private NodeNameComparator() {
        }

        @Override
        public int compare(DBNNode node1, DBNNode node2) {
            return node1.getNodeDisplayName().compareToIgnoreCase(node2.getNodeDisplayName());
        }
    }
}

