/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.engine.copilot;

import java.util.List;
import java.util.concurrent.Flow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.engine.AIEngineRequest;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponse;
import org.jkiss.dbeaver.model.ai.engine.AIEngineResponseChunk;
import org.jkiss.dbeaver.model.ai.engine.BaseCompletionEngine;
import org.jkiss.dbeaver.model.ai.engine.LegacyAISettings;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotClient;
import org.jkiss.dbeaver.model.ai.engine.copilot.CopilotProperties;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotChatChunk;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotChatRequest;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotMessage;
import org.jkiss.dbeaver.model.ai.engine.copilot.dto.CopilotSessionToken;
import org.jkiss.dbeaver.model.ai.engine.openai.OpenAIModel;
import org.jkiss.dbeaver.model.ai.registry.AISettingsRegistry;
import org.jkiss.dbeaver.model.ai.utils.DisposableLazyValue;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class CopilotCompletionEngine
extends BaseCompletionEngine<CopilotProperties> {
    private static final Log log = Log.getLog(CopilotCompletionEngine.class);
    private final DisposableLazyValue<CopilotClient, DBException> client = new DisposableLazyValue<CopilotClient, DBException>(){

        @Override
        @NotNull
        protected CopilotClient initialize() {
            return new CopilotClient();
        }

        @Override
        protected void onDispose(CopilotClient disposedValue) {
            disposedValue.close();
        }
    };
    private volatile CopilotSessionToken sessionToken;

    public CopilotCompletionEngine(AISettingsRegistry registry) {
        super(registry);
    }

    @Override
    public int getMaxContextSize(@NotNull DBRProgressMonitor monitor) throws DBException {
        return OpenAIModel.getByName(this.getModelName()).getMaxTokens();
    }

    @Override
    @NotNull
    public AIEngineResponse requestCompletion(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        CopilotChatRequest chatRequest = CopilotChatRequest.builder().withModel(this.getModelName()).withMessages(request.messages().stream().map(CopilotMessage::from).toList()).withTemperature(this.getProperties().getTemperature()).withStream(false).withIntent(false).withTopP(1).withN(1).build();
        List<String> choices = ((CopilotClient)this.client.getInstance()).chat(monitor, this.requestSessionToken(monitor).token(), chatRequest).choices().stream().map(it -> it.message().content()).toList();
        return new AIEngineResponse(choices);
    }

    @Override
    @NotNull
    public Flow.Publisher<AIEngineResponseChunk> requestCompletionStream(@NotNull DBRProgressMonitor monitor, @NotNull AIEngineRequest request) throws DBException {
        CopilotChatRequest chatRequest = CopilotChatRequest.builder().withModel(this.getModelName()).withMessages(request.messages().stream().map(CopilotMessage::from).toList()).withTemperature(this.getProperties().getTemperature()).withStream(true).withIntent(false).withTopP(1).withN(1).build();
        Flow.Publisher<CopilotChatChunk> chunkPublisher = ((CopilotClient)this.client.getInstance()).createChatCompletionStream(monitor, this.requestSessionToken(monitor).token(), chatRequest);
        return subscriber -> chunkPublisher.subscribe(new Flow.Subscriber<CopilotChatChunk>(){

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                subscriber.onSubscribe(subscription);
            }

            @Override
            public void onNext(CopilotChatChunk chunk) {
                List<String> choices = chunk.choices().stream().takeWhile(it -> it.delta().content() != null).map(it -> it.delta().content()).toList();
                subscriber.onNext(new AIEngineResponseChunk(choices));
            }

            @Override
            public void onError(Throwable throwable) {
                subscriber.onError(throwable);
            }

            @Override
            public void onComplete() {
                subscriber.onComplete();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSettingsUpdate(@NotNull AISettingsRegistry registry) {
        try {
            this.client.dispose();
        }
        catch (DBException e) {
            log.error((Object)"Error disposing client", (Throwable)e);
        }
        CopilotCompletionEngine copilotCompletionEngine = this;
        synchronized (copilotCompletionEngine) {
            this.sessionToken = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CopilotSessionToken requestSessionToken(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.sessionToken != null) {
            return this.sessionToken;
        }
        CopilotCompletionEngine copilotCompletionEngine = this;
        synchronized (copilotCompletionEngine) {
            if (this.sessionToken != null) {
                return this.sessionToken;
            }
            return ((CopilotClient)this.client.getInstance()).requestSessionToken(monitor, this.getProperties().getToken());
        }
    }

    public String getModelName() throws DBException {
        return CommonUtils.toString((Object)this.getProperties().getModel(), (String)OpenAIModel.GPT_TURBO.getName());
    }

    @Override
    protected CopilotProperties getProperties() throws DBException {
        return (CopilotProperties)((LegacyAISettings)this.registry.getSettings().getEngineConfiguration("copilot")).getProperties();
    }
}

