/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport;

import net.schmizz.sshj.transport.cipher.Cipher;
import net.schmizz.sshj.transport.cipher.NoneCipher;
import net.schmizz.sshj.transport.compression.Compression;
import net.schmizz.sshj.transport.mac.MAC;

abstract class Converter {
    protected Cipher cipher = new NoneCipher();
    protected MAC mac = null;
    protected Compression compression = null;
    protected int cipherSize = 8;
    protected long seq = -1L;
    protected boolean authed;
    protected boolean etm;
    protected boolean authMode;

    Converter() {
    }

    long getSequenceNumber() {
        return this.seq;
    }

    void resetSequenceNumber() {
        this.seq = -1L;
    }

    boolean isSequenceNumberAtMax() {
        return this.seq == 0xFFFFFFFFL;
    }

    void setAlgorithms(Cipher cipher, MAC mac, Compression compression) {
        this.cipher = cipher;
        this.mac = mac;
        this.compression = compression;
        if (compression != null) {
            compression.init(this.getCompressionType());
        }
        this.cipherSize = cipher.getIVSize();
        boolean bl = this.etm = this.mac != null && mac.isEtm();
        if (cipher.getAuthenticationTagSize() > 0) {
            this.cipherSize = cipher.getAuthenticationTagSize();
            this.authMode = true;
        }
    }

    void setAuthenticated() {
        this.authed = true;
    }

    boolean usingCompression() {
        return this.compression != null && (this.authed || !this.compression.isDelayed());
    }

    abstract Compression.Mode getCompressionType();
}

