/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBIconComposite;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCFeatureNotSupportedException;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNNodeExtendable;
import org.jkiss.dbeaver.model.navigator.DBNNodeWithCache;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.navigator.registry.DBNRegistry;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class DBNProject
extends DBNNode
implements DBNNodeWithCache,
DBNNodeExtendable {
    private static final Log log = Log.getLog(DBNProject.class);
    private final DBPProject project;
    private List<DBNNode> extraNodes;
    private DBNNode[] children;

    public DBNProject(DBNNode parentNode, DBPProject project) {
        super(parentNode);
        this.project = project;
        DBNRegistry.getInstance().extendNode(this, false);
    }

    @NotNull
    public DBPProject getProject() {
        return this.project;
    }

    public DBNProjectDatabases getDatabases() {
        try {
            DBNNode[] dBNNodeArray = this.getChildren(new VoidProgressMonitor());
            int n = dBNNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBNNode db = dBNNodeArray[n2];
                if (db instanceof DBNProjectDatabases) {
                    DBNProjectDatabases databases = (DBNProjectDatabases)db;
                    return databases;
                }
                ++n2;
            }
        }
        catch (DBException e) {
            throw new IllegalStateException("Can't read project contents", e);
        }
        throw new IllegalStateException("No databases resource in project");
    }

    @Override
    @NotNull
    public String getName() {
        return this.project.getId();
    }

    @Override
    public String getNodeDisplayName() {
        return this.project.getDisplayName();
    }

    @Override
    public String getNodeDescription() {
        return null;
    }

    @Override
    public String getLocalizedName(String locale) {
        return this.getNodeDisplayName();
    }

    @Override
    public String getNodeType() {
        return "project";
    }

    @Override
    @NotNull
    public DBPImage getNodeIcon() {
        DBPImage image = DBIcon.PROJECT;
        if (this.getProject().isPrivateProject()) {
            image = new DBIconComposite(image, false, null, null, null, DBIcon.OVER_LAMP);
        } else if (!this.getProject().hasRealmPermission("project-datasource-edit")) {
            image = new DBIconComposite(image, false, null, null, null, DBIcon.OVER_LOCK);
        }
        return image;
    }

    @Override
    public boolean allowsOpen() {
        return true;
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBNProject.class) {
            return adapter.cast(this);
        }
        return super.getAdapter(adapter);
    }

    @Override
    @Nullable
    public DBPProject getOwnerProjectOrNull() {
        return this.project;
    }

    @Override
    public Throwable getLastLoadError() {
        return this.getProject().getDataSourceRegistry().getLastError();
    }

    @Override
    public boolean supportsRename() {
        return !this.project.isVirtual();
    }

    @Override
    public void rename(DBRProgressMonitor monitor, String newName) throws DBException {
        throw new DBCFeatureNotSupportedException("Project rename is not supported");
    }

    protected DBNNode[] readChildNodes(DBRProgressMonitor monitor) throws DBException {
        if (this.getModel().isGlobal() && !this.project.isOpen()) {
            this.project.ensureOpen();
        }
        DBPDataSourceRegistry dataSourceRegistry = this.project.getDataSourceRegistry();
        try {
            dataSourceRegistry.checkForErrors();
        }
        catch (Throwable e) {
            this.project.dispose();
            throw e;
        }
        ArrayList<DBNNode> children = new ArrayList<DBNNode>();
        children.add(new DBNProjectDatabases(this, dataSourceRegistry));
        this.addProjectNodes(monitor, children);
        if (!CommonUtils.isEmpty(this.extraNodes)) {
            children.addAll(this.extraNodes);
        }
        this.filterChildren(children);
        return (DBNNode[])children.toArray(DBNNode[]::new);
    }

    protected void addProjectNodes(DBRProgressMonitor monitor, List<DBNNode> children) throws DBException {
    }

    protected void filterChildren(List<DBNNode> children) {
    }

    @Override
    public DBNNode refreshNode(DBRProgressMonitor monitor, Object source) throws DBException {
        this.project.getDataSourceRegistry().refreshConfig();
        return this;
    }

    public DBNNode findResource(DBRProgressMonitor monitor, Path path) throws DBException {
        Path relativePath = this.getProject().getAbsolutePath().relativize(path);
        DBNNode resNode = this;
        for (Path fileName : relativePath) {
            if ((resNode = (DBNNode)DBUtils.findObject((DBPNamedObject[])((DBNNode)resNode).getChildren(monitor), (String)fileName.toString())) == null) break;
        }
        return resNode;
    }

    @Override
    @NotNull
    public List<DBNNode> getExtraNodes() {
        if (this.extraNodes == null) {
            return Collections.emptyList();
        }
        return this.extraNodes;
    }

    public <T> T getExtraNode(Class<T> nodeType) {
        if (this.extraNodes != null) {
            for (DBNNode node : this.extraNodes) {
                if (!nodeType.isAssignableFrom(node.getClass())) continue;
                return nodeType.cast(node);
            }
        }
        return null;
    }

    @Override
    public void addExtraNode(@NotNull DBNNode node, boolean reflect) {
        if (this.extraNodes == null) {
            this.extraNodes = new ArrayList<DBNNode>();
        }
        this.extraNodes.add(node);
        this.extraNodes.sort(Comparator.comparing(DBNNode::getNodeDisplayName));
        if (reflect) {
            this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.ADD, node));
        }
    }

    @Override
    public void removeExtraNode(@NotNull DBNNode node) {
        if (this.extraNodes != null && this.extraNodes.remove(node)) {
            this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.REMOVE, node));
        }
    }

    @Override
    protected void dispose(boolean reflect) {
        if (this.extraNodes != null) {
            for (DBNNode node : this.extraNodes) {
                DBNUtils.disposeNode(node, reflect);
            }
            this.extraNodes.clear();
        }
        if (this.children != null) {
            DBNNode[] dBNNodeArray = this.children;
            int n = this.children.length;
            int n2 = 0;
            while (n2 < n) {
                DBNNode child = dBNNodeArray[n2];
                DBNUtils.disposeNode(child, reflect);
                ++n2;
            }
            this.children = null;
        }
        if (reflect) {
            this.getModel().fireNodeEvent(new DBNEvent(this, DBNEvent.Action.REMOVE, this));
        }
        super.dispose(reflect);
    }

    @Override
    @NotNull
    public String getNodeId() {
        return this.project.getId();
    }

    @Override
    @Deprecated
    public String getNodeItemPath() {
        return DBNNode.NodePathType.resource.getPrefix() + this.project.getId();
    }

    @Override
    public boolean hasChildren(boolean navigableOnly) {
        return true;
    }

    @Override
    protected boolean allowsChildren() {
        return true;
    }

    @Override
    public DBNNode[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.children != null) {
            return this.children;
        }
        this.children = this.readChildNodes(monitor);
        return this.children;
    }

    @Override
    public boolean needsInitialization() {
        return this.children == null;
    }

    @Override
    public DBNNode[] getCachedChildren() {
        return this.children;
    }

    @Override
    public void setCachedChildren(DBNNode[] children) {
        this.children = children;
    }
}

